/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.mtrsteamloco.MainClient;
import forge.cn.zbx1425.mtrsteamloco.data.EyeCandyProperties;
import forge.cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.ScriptHolder;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcerext.model.ModelCluster;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import forge.cn.zbx1425.sowcerext.util.ResourceUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class EyeCandyRegistry {
    public static Map<String, EyeCandyProperties> elements = new HashMap<String, EyeCandyProperties>();

    public static void register(String key, EyeCandyProperties properties) {
        elements.put(key, properties);
    }

    public static void reload(ResourceManager resourceManager) {
        elements.clear();
        List<Pair<ResourceLocation, Resource>> resources = MtrModelRegistryUtil.listResources(resourceManager, "mtrsteamloco", "eyecandies", ".json");
        for (Pair<ResourceLocation, Resource> pair : resources) {
            try {
                InputStream is = Utilities.getInputStream((Resource)((Resource)pair.getSecond()));
                try {
                    JsonObject rootObj = new JsonParser().parse(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
                    if (rootObj.has("model")) {
                        String key = FilenameUtils.getBaseName((String)((ResourceLocation)pair.getFirst()).m_135815_());
                        EyeCandyRegistry.register(key, EyeCandyRegistry.loadFromJson(resourceManager, key, rootObj));
                        continue;
                    }
                    for (Map.Entry entry : rootObj.entrySet()) {
                        JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                        EyeCandyRegistry.register(key, EyeCandyRegistry.loadFromJson(resourceManager, key, obj));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception ex) {
                Main.LOGGER.error("Failed loading eye-candy: " + ((ResourceLocation)pair.getFirst()).toString(), (Throwable)ex);
                MtrModelRegistryUtil.recordLoadingError("Failed loading Eye-candy " + ((ResourceLocation)pair.getFirst()).toString(), ex);
            }
        }
    }

    public static EyeCandyProperties getProperty(String key) {
        return elements.getOrDefault(key, null);
    }

    private static EyeCandyProperties loadFromJson(ResourceManager resourceManager, String key, JsonObject obj) throws Exception {
        if (obj.has("atlasIndex")) {
            MainClient.atlasManager.load(MtrModelRegistryUtil.resourceManager, new ResourceLocation(obj.get("atlasIndex").getAsString()));
        }
        if (obj.has("model")) {
            JsonArray vec;
            RawModel rawModel = MainClient.modelManager.loadRawModel(resourceManager, new ResourceLocation(obj.get("model").getAsString()), MainClient.atlasManager).copy();
            if (obj.has("textureId")) {
                rawModel.replaceTexture("default.png", new ResourceLocation(obj.get("textureId").getAsString()));
            }
            if (obj.has("flipV") && obj.get("flipV").getAsBoolean()) {
                rawModel.applyUVMirror(false, true);
            }
            if (obj.has("translation")) {
                vec = obj.get("translation").getAsJsonArray();
                rawModel.applyTranslation(vec.get(0).getAsFloat(), vec.get(1).getAsFloat(), vec.get(2).getAsFloat());
            }
            if (obj.has("rotation")) {
                vec = obj.get("rotation").getAsJsonArray();
                rawModel.applyRotation(new Vector3f(1.0f, 0.0f, 0.0f), vec.get(0).getAsFloat());
                rawModel.applyRotation(new Vector3f(0.0f, 1.0f, 0.0f), vec.get(1).getAsFloat());
                rawModel.applyRotation(new Vector3f(0.0f, 0.0f, 1.0f), vec.get(2).getAsFloat());
            }
            if (obj.has("scale")) {
                vec = obj.get("scale").getAsJsonArray();
                rawModel.applyScale(vec.get(0).getAsFloat(), vec.get(1).getAsFloat(), vec.get(2).getAsFloat());
            }
            if (obj.has("mirror")) {
                vec = obj.get("mirror").getAsJsonArray();
                rawModel.applyMirror(vec.get(0).getAsBoolean(), vec.get(1).getAsBoolean(), vec.get(2).getAsBoolean(), vec.get(0).getAsBoolean(), vec.get(1).getAsBoolean(), vec.get(2).getAsBoolean());
            }
            rawModel.sourceLocation = new ResourceLocation(rawModel.sourceLocation.toString() + "/" + key);
            ModelCluster cluster = MainClient.modelManager.uploadVertArrays(rawModel);
            return new EyeCandyProperties((Component)Text.translatable((String)obj.get("name").getAsString(), (Object[])new Object[0]), cluster);
        }
        if (obj.has("scriptFiles")) {
            int i;
            ScriptHolder scriptContext = new ScriptHolder();
            Object2ObjectArrayMap scripts = new Object2ObjectArrayMap();
            if (obj.has("scriptTexts")) {
                JsonArray scriptTexts = obj.get("scriptTexts").getAsJsonArray();
                for (i = 0; i < scriptTexts.size(); ++i) {
                    scripts.put(new ResourceLocation("mtrsteamloco", "script_texts/" + key + "/" + i), scriptTexts.get(i).getAsString());
                }
            }
            JsonArray scriptFiles = obj.get("scriptFiles").getAsJsonArray();
            for (i = 0; i < scriptFiles.size(); ++i) {
                ResourceLocation scriptLocation = new ResourceLocation(scriptFiles.get(i).getAsString());
                scripts.put(scriptLocation, ResourceUtil.readResource(resourceManager, scriptLocation));
            }
            scriptContext.load("EyeCandy " + key, "Block", resourceManager, (Map<ResourceLocation, String>)scripts);
            return new EyeCandyProperties((Component)Text.translatable((String)obj.get("name").getAsString(), (Object[])new Object[0]), scriptContext);
        }
        throw new IllegalArgumentException("Invalid eye-candy json: " + key);
    }
}

