/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.data;

import forge.cn.zbx1425.mtrsteamloco.MainClient;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcer.model.Model;
import forge.cn.zbx1425.sowcer.vertex.VertAttrType;
import forge.cn.zbx1425.sowcerext.model.RawMesh;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import forge.cn.zbx1425.sowcerext.model.Vertex;
import net.minecraft.network.chat.Component;

public class RailModelProperties {
    public Component name;
    public RawModel rawModel;
    public Model uploadedModel;
    public Long boundingBox;
    public float repeatInterval;
    public float yOffset;

    public RailModelProperties(Component name, RawModel rawModel, float repeatInterval, float yOffset) {
        this.name = name;
        if (rawModel == null) {
            this.rawModel = null;
            this.uploadedModel = null;
            this.boundingBox = 0L;
            this.repeatInterval = repeatInterval;
            this.yOffset = yOffset;
            return;
        }
        this.yOffset = yOffset;
        rawModel.clearAttrState(VertAttrType.COLOR);
        rawModel.applyRotation(new Vector3f(0.577f, 0.577f, 0.577f), (float)Math.toRadians(1.0));
        this.rawModel = rawModel;
        this.uploadedModel = MainClient.modelManager.uploadModel(rawModel);
        float yMin = 0.0f;
        float yMax = 0.0f;
        for (RawMesh mesh : rawModel.meshList.values()) {
            for (Vertex vertex : mesh.vertices) {
                yMin = Math.min(yMin, vertex.position.y() + yOffset);
                yMax = Math.max(yMax, vertex.position.y() + yOffset);
            }
        }
        this.boundingBox = (long)Float.floatToIntBits(yMin) << 32 | (long)Float.floatToIntBits(yMax);
        this.repeatInterval = repeatInterval;
    }
}

