/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.mtrsteamloco.MainClient;
import forge.cn.zbx1425.mtrsteamloco.data.RailModelProperties;
import forge.cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import forge.cn.zbx1425.sowcerext.model.ModelCluster;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class RailModelRegistry {
    public static Map<String, RailModelProperties> elements = new HashMap<String, RailModelProperties>();
    public static ModelCluster railNodeModel;
    private static final RailModelProperties EMPTY_PROPERTY;

    public static void register(String key, RailModelProperties properties) {
        elements.put(key, properties);
    }

    public static void reload(ResourceManager resourceManager) {
        elements.clear();
        RailModelRegistry.register("", new RailModelProperties((Component)Text.translatable((String)"rail.mtrsteamloco.default", (Object[])new Object[0]), null, 1.0f, 0.0f));
        RailModelRegistry.register("null", new RailModelProperties((Component)Text.translatable((String)"rail.mtrsteamloco.hidden", (Object[])new Object[0]), null, Float.MAX_VALUE, 0.0f));
        try {
            RawModel railNodeRawModel = MainClient.modelManager.loadRawModel(resourceManager, new ResourceLocation("mtrsteamloco:models/rail_node.csv"), MainClient.atlasManager);
            railNodeModel = MainClient.modelManager.uploadVertArrays(railNodeRawModel);
        }
        catch (Exception ex) {
            Main.LOGGER.error("Failed loading rail node model", (Throwable)ex);
            MtrModelRegistryUtil.recordLoadingError("Failed loading Rail Node", ex);
        }
        List<Pair<ResourceLocation, Resource>> resources = MtrModelRegistryUtil.listResources(resourceManager, "mtrsteamloco", "rails", ".json");
        for (Pair<ResourceLocation, Resource> pair : resources) {
            try {
                InputStream is = Utilities.getInputStream((Resource)((Resource)pair.getSecond()));
                try {
                    JsonObject rootObj = new JsonParser().parse(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
                    if (rootObj.has("model")) {
                        String key = FilenameUtils.getBaseName((String)((ResourceLocation)pair.getFirst()).m_135815_());
                        RailModelRegistry.register(key, RailModelRegistry.loadFromJson(resourceManager, key, rootObj));
                        continue;
                    }
                    for (Map.Entry entry : rootObj.entrySet()) {
                        JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                        RailModelRegistry.register(key, RailModelRegistry.loadFromJson(resourceManager, key, obj));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception ex) {
                Main.LOGGER.error("Failed loading rail: " + ((ResourceLocation)pair.getFirst()).toString(), (Throwable)ex);
                MtrModelRegistryUtil.recordLoadingError("Failed loading Rail " + ((ResourceLocation)pair.getFirst()).toString(), ex);
            }
        }
        MainClient.railRenderDispatcher.clearRail();
    }

    public static RailModelProperties getProperty(String key) {
        return elements.getOrDefault(key, EMPTY_PROPERTY);
    }

    private static RailModelProperties loadFromJson(ResourceManager resourceManager, String key, JsonObject obj) throws IOException {
        if (obj.has("atlasIndex")) {
            MainClient.atlasManager.load(MtrModelRegistryUtil.resourceManager, new ResourceLocation(obj.get("atlasIndex").getAsString()));
        }
        RawModel rawModel = MainClient.modelManager.loadRawModel(resourceManager, new ResourceLocation(obj.get("model").getAsString()), MainClient.atlasManager).copy();
        if (obj.has("textureId")) {
            rawModel.replaceTexture("default.png", new ResourceLocation(obj.get("textureId").getAsString()));
        }
        if (obj.has("flipV") && obj.get("flipV").getAsBoolean()) {
            rawModel.applyUVMirror(false, true);
        }
        rawModel.sourceLocation = new ResourceLocation(rawModel.sourceLocation.toString() + "/" + key);
        float repeatInterval = obj.has("repeatInterval") ? obj.get("repeatInterval").getAsFloat() : 0.5f;
        float yOffset = obj.has("yOffset") ? obj.get("yOffset").getAsFloat() : 0.0f;
        return new RailModelProperties((Component)Text.translatable((String)obj.get("name").getAsString(), (Object[])new Object[0]), rawModel, repeatInterval, yOffset);
    }

    static {
        EMPTY_PROPERTY = new RailModelProperties((Component)Text.literal((String)""), null, 1.0f, 0.0f);
    }
}

