/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import forge.cn.zbx1425.mtrsteamloco.data.RailExtraSupplier;
import forge.cn.zbx1425.mtrsteamloco.data.RailModelProperties;
import forge.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import forge.cn.zbx1425.mtrsteamloco.gui.SelectListScreen;
import forge.cn.zbx1425.mtrsteamloco.gui.WidgetLabel;
import forge.cn.zbx1425.mtrsteamloco.network.PacketUpdateHoldingItem;
import forge.cn.zbx1425.mtrsteamloco.network.PacketUpdateRail;
import forge.cn.zbx1425.mtrsteamloco.render.RailPicker;
import java.util.List;
import java.util.function.Consumer;
import mtr.Items;
import mtr.client.IDrawing;
import mtr.data.Rail;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BrushEditRailScreen
extends SelectListScreen {
    private boolean isSelectingModel = false;
    private static final String INSTRUCTION_LINK = "https://www.zbx1425.cn/nautilus/mtr-nte/#/railmodel";
    private final WidgetLabel lblInstruction = new WidgetLabel(0, 0, 0, (Component)Text.translatable((String)"gui.mtrsteamloco.eye_candy.tip_resource_pack", (Object[])new Object[0]), () -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bl -> {
        if (bl) {
            Util.m_137581_().m_137646_(INSTRUCTION_LINK);
        }
        this.f_96541_.m_91152_((Screen)this);
    }, INSTRUCTION_LINK, true)));
    private static Rail pickedRail = null;
    private static BlockPos pickedPosStart = BlockPos.f_121853_;
    private static BlockPos pickedPosEnd = BlockPos.f_121853_;
    Button btnSetDefaultRadius = UtilitiesClient.newButton((Component)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_set_max", (Object[])new Object[0]), sender -> this.updateRadius(0.0f, true));
    Button btnSetNoRadius = UtilitiesClient.newButton((Component)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_set_none", (Object[])new Object[0]), sender -> this.updateRadius(-1.0f, true));
    WidgetLabel valuesLabel = new WidgetLabel(20, 146, this.f_96543_ - 40, (Component)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_irl_ref", (Object[])new Object[0]));
    WidgetBetterTextField radiusInput = new WidgetBetterTextField("", 8);

    public BrushEditRailScreen() {
        super((Component)Text.literal((String)"Select rail arguments"));
        if (pickedRail == null) {
            BrushEditRailScreen.acquirePickInfoWhenUse();
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.loadPage();
    }

    @Override
    protected void loadPage() {
        this.m_169413_();
        if (this.isSelectingModel) {
            CompoundTag brushTag = this.getBrushTag();
            String modelKey = brushTag == null ? "" : brushTag.m_128461_("ModelKey");
            this.scrollList.f_93624_ = true;
            this.loadSelectPage(key -> !key.equals(modelKey));
            this.lblInstruction.alignR = true;
            IDrawing.setPositionAndWidth((AbstractWidget)this.lblInstruction, (int)(this.f_96543_ / 2 + 20), (int)(this.f_96544_ - 20 - 8), (int)0);
            this.lblInstruction.m_93674_(this.f_96543_ / 2 - 40);
            this.m_142416_((GuiEventListener)this.lblInstruction);
        } else {
            this.scrollList.f_93624_ = false;
            this.loadMainPage();
        }
    }

    @Override
    protected void onBtnClick(String btnKey) {
        this.updateBrushTag(compoundTag -> compoundTag.m_128359_("ModelKey", btnKey));
    }

    private void loadMainPage() {
        CompoundTag brushTag = this.getBrushTag();
        this.m_142416_((GuiEventListener)new WidgetLabel(20, 22, this.f_96543_ - 40, (Component)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.brush_hint", (Object[])new Object[0])));
        boolean enableModelKey = brushTag != null && brushTag.m_128441_("ModelKey");
        String modelKey = ((RailExtraSupplier)pickedRail).getModelKey();
        ((WidgetBetterCheckbox)this.m_142416_((GuiEventListener)new WidgetBetterCheckbox(20, 40, 160, 20, (Component)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.enable_model_key", (Object[])new Object[0]), checked -> {
            this.updateBrushTag(compoundTag -> {
                if (checked) {
                    compoundTag.m_128359_("ModelKey", modelKey);
                } else {
                    compoundTag.m_128473_("ModelKey");
                }
            });
            this.loadPage();
        }))).setChecked(enableModelKey);
        if (enableModelKey) {
            RailModelProperties properties = RailModelRegistry.elements.get(modelKey);
            IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)UtilitiesClient.newButton((Component)(properties != null ? properties.name : Text.literal((String)(modelKey + " (???)"))), sender -> {
                this.isSelectingModel = true;
                this.loadPage();
            }))), (int)20, (int)60, (int)240);
        }
        boolean enableVertCurveRadius = brushTag != null && brushTag.m_128441_("VerticalCurveRadius");
        float vertCurveRadius = ((RailExtraSupplier)pickedRail).getVerticalCurveRadius();
        ((WidgetBetterCheckbox)this.m_142416_((GuiEventListener)new WidgetBetterCheckbox(20, 100, 160, 20, (Component)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.enable_vertical_curve_radius", (Object[])new Object[0]), checked -> {
            this.updateBrushTag(compoundTag -> {
                if (checked) {
                    compoundTag.m_128350_("VerticalCurveRadius", vertCurveRadius);
                } else {
                    compoundTag.m_128473_("VerticalCurveRadius");
                }
            });
            this.loadPage();
        }))).setChecked(enableVertCurveRadius);
        if (enableVertCurveRadius) {
            this.updateRadius(vertCurveRadius, false);
            this.radiusInput.m_94151_(text -> {
                if (!text.isEmpty()) {
                    try {
                        float newRadius = Float.parseFloat(text);
                        Rail rail = pickedRail;
                        if (rail != null) {
                            double maxRadius;
                            int H = Math.abs(((RailExtraSupplier)rail).getHeight());
                            double L = rail.getLength();
                            double d = maxRadius = H == 0 ? 0.0 : ((double)(H * H) + L * L) / (double)(H * 4);
                            if ((double)newRadius < maxRadius) {
                                this.radiusInput.m_94202_(0xE0E0E0);
                            } else {
                                this.radiusInput.m_94202_(0xEEEE00);
                            }
                        } else {
                            this.radiusInput.m_94202_(0xEEEE00);
                        }
                        this.updateRadius(newRadius, true);
                    }
                    catch (Exception ignored) {
                        this.radiusInput.m_94202_(0xFF0000);
                    }
                }
            });
            IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)this.radiusInput)), (int)20, (int)120, (int)160);
            IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)this.btnSetDefaultRadius)), (int)180, (int)120, (int)80);
            IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)this.btnSetNoRadius)), (int)260, (int)120, (int)80);
            this.valuesLabel.m_93674_(this.f_96543_ - 40);
            this.m_142416_((GuiEventListener)this.valuesLabel);
        }
    }

    private void updateRadius(float newRadius, boolean send) {
        this.valuesLabel.m_93666_((Component)Text.literal((String)this.getVerticalValueText(newRadius)));
        this.btnSetDefaultRadius.f_93623_ = newRadius != 0.0f;
        this.btnSetNoRadius.f_93623_ = newRadius >= 0.0f;
        String expectedText = newRadius <= 0.0f ? "" : Integer.toString((int)newRadius);
        if (!expectedText.equals(this.radiusInput.m_94155_())) {
            this.radiusInput.m_94144_(expectedText);
            this.radiusInput.m_94198_();
        }
        if (send) {
            this.updateBrushTag(compoundTag -> compoundTag.m_128350_("VerticalCurveRadius", newRadius));
        }
    }

    private String getVerticalValueText(float verticalRadius) {
        double maxRadius;
        Rail rail = pickedRail;
        if (rail == null) {
            return "(???)";
        }
        int H = Math.abs(((RailExtraSupplier)rail).getHeight());
        double L = rail.getLength();
        double d = maxRadius = H == 0 ? 0.0 : ((double)(H * H) + L * L) / (double)(H * 4);
        double gradient = verticalRadius < 0.0f ? (double)H / L * 1000.0 : (verticalRadius == 0.0f || (double)verticalRadius > maxRadius ? Math.tan(RailExtraSupplier.getVTheta(rail, maxRadius)) * 1000.0 : Math.tan(RailExtraSupplier.getVTheta(rail, verticalRadius)) * 1000.0);
        return Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_values", (Object[])new Object[]{String.format("%.1f", maxRadius), String.format("%.1f", gradient)}).getString();
    }

    @Override
    protected List<Pair<String, String>> getRegistryEntries() {
        return RailModelRegistry.elements.entrySet().stream().filter(e -> !((RailModelProperties)e.getValue()).name.getString().isEmpty()).map(e -> new Pair((Object)((String)e.getKey()), (Object)((RailModelProperties)e.getValue()).name.getString())).toList();
    }

    private CompoundTag getBrushTag() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return null;
        }
        ItemStack brushItem = Minecraft.m_91087_().f_91074_.m_21205_();
        if (!brushItem.m_150930_((Item)Items.BRUSH.get())) {
            return null;
        }
        CompoundTag nteTag = brushItem.m_41737_("NTERailBrush");
        return nteTag;
    }

    private void updateBrushTag(Consumer<CompoundTag> modifier) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        ItemStack brushItem = Minecraft.m_91087_().f_91074_.m_21205_();
        if (!brushItem.m_150930_((Item)Items.BRUSH.get())) {
            return;
        }
        CompoundTag nteTag = brushItem.m_41698_("NTERailBrush");
        modifier.accept(nteTag);
        BrushEditRailScreen.applyBrushToPickedRail(nteTag, false);
        PacketUpdateHoldingItem.sendUpdateC2S();
    }

    public static void acquirePickInfoWhenUse() {
        pickedRail = RailPicker.pickedRail;
        pickedPosStart = RailPicker.pickedPosStart;
        pickedPosEnd = RailPicker.pickedPosEnd;
    }

    public static void applyBrushToPickedRail(CompoundTag railBrushProp, boolean isBatchApply) {
        if (railBrushProp == null) {
            return;
        }
        if (pickedRail == null) {
            return;
        }
        RailExtraSupplier pickedExtra = (RailExtraSupplier)pickedRail;
        boolean propertyUpdated = false;
        if (railBrushProp.m_128441_("ModelKey") && !railBrushProp.m_128461_("ModelKey").equals(pickedExtra.getModelKey())) {
            pickedExtra.setModelKey(railBrushProp.m_128461_("ModelKey"));
            propertyUpdated = true;
        }
        if (railBrushProp.m_128441_("VerticalCurveRadius") && railBrushProp.m_128457_("VerticalCurveRadius") != pickedExtra.getVerticalCurveRadius()) {
            pickedExtra.setVerticalCurveRadius(railBrushProp.m_128457_("VerticalCurveRadius"));
            propertyUpdated = true;
        }
        if (isBatchApply && !propertyUpdated) {
            pickedExtra.setRenderReversed(!pickedExtra.getRenderReversed());
        }
        PacketUpdateRail.sendUpdateC2S(pickedRail, pickedPosStart, pickedPosEnd);
    }

    public void m_86412_(PoseStack guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(guiGraphics);
        super.m_86412_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isSelectingModel) {
            this.renderSelectPage(guiGraphics);
        }
    }

    public void m_7379_() {
        if (this.isSelectingModel) {
            this.isSelectingModel = false;
            this.loadPage();
        } else {
            this.f_96541_.m_91152_(null);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

