/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.mtrsteamloco.block.BlockEyeCandy;
import forge.cn.zbx1425.mtrsteamloco.data.EyeCandyProperties;
import forge.cn.zbx1425.mtrsteamloco.data.EyeCandyRegistry;
import forge.cn.zbx1425.mtrsteamloco.gui.SelectListScreen;
import forge.cn.zbx1425.mtrsteamloco.gui.WidgetLabel;
import forge.cn.zbx1425.mtrsteamloco.gui.WidgetSlider;
import forge.cn.zbx1425.mtrsteamloco.network.PacketUpdateBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterCheckbox;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;

public class EyeCandyScreen
extends SelectListScreen {
    private boolean isSelectingModel = false;
    private static final String INSTRUCTION_LINK = "https://www.zbx1425.cn/nautilus/mtr-nte/#/eyecandy";
    private final WidgetLabel lblInstruction = new WidgetLabel(0, 0, 0, (Component)Text.translatable((String)"gui.mtrsteamloco.eye_candy.tip_resource_pack", (Object[])new Object[0]), () -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bl -> {
        if (bl) {
            Util.m_137581_().m_137646_(INSTRUCTION_LINK);
        }
        this.f_96541_.m_91152_((Screen)this);
    }, INSTRUCTION_LINK, true)));
    private final BlockPos editingBlockPos;

    public EyeCandyScreen(BlockPos blockPos) {
        super((Component)Text.literal((String)"Select EyeCandy"));
        this.editingBlockPos = blockPos;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.loadPage();
    }

    public void m_86412_(@NotNull PoseStack guiGraphics, int i, int j, float f) {
        this.m_7333_(guiGraphics);
        super.m_86412_(guiGraphics, i, j, f);
        if (this.isSelectingModel) {
            super.renderSelectPage(guiGraphics);
        }
    }

    @Override
    protected void loadPage() {
        this.m_169413_();
        Optional<BlockEyeCandy.BlockEntityEyeCandy> optionalBlockEntity = this.getBlockEntity();
        if (optionalBlockEntity.isEmpty()) {
            this.m_7379_();
            return;
        }
        BlockEyeCandy.BlockEntityEyeCandy blockEntity = optionalBlockEntity.get();
        if (this.isSelectingModel) {
            this.scrollList.f_93624_ = true;
            this.loadSelectPage(key -> !key.equals(blockEntity.prefabId));
            this.lblInstruction.alignR = true;
            IDrawing.setPositionAndWidth((AbstractWidget)this.lblInstruction, (int)(this.f_96543_ / 2 + 20), (int)(this.f_96544_ - 20 - 8), (int)0);
            this.lblInstruction.m_93674_(this.f_96543_ / 2 - 40);
            this.m_142416_((GuiEventListener)this.lblInstruction);
        } else {
            this.scrollList.f_93624_ = false;
            this.loadMainPage(blockEntity);
        }
    }

    @Override
    protected void onBtnClick(String btnKey) {
        this.updateBlockEntity(blockEntity -> {
            blockEntity.prefabId = btnKey;
        });
    }

    @Override
    protected List<Pair<String, String>> getRegistryEntries() {
        return EyeCandyRegistry.elements.entrySet().stream().map(e -> new Pair((Object)((String)e.getKey()), (Object)((EyeCandyProperties)e.getValue()).name.getString())).toList();
    }

    private void loadMainPage(BlockEyeCandy.BlockEntityEyeCandy blockEntity) {
        EyeCandyProperties properties = EyeCandyRegistry.elements.get(blockEntity.prefabId);
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)UtilitiesClient.newButton((Component)(properties != null ? properties.name : Text.literal((String)(blockEntity.prefabId + " (???)"))), sender -> {
            this.isSelectingModel = true;
            this.loadPage();
        }))), (int)20, (int)20, (int)240);
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)new WidgetSlider(40, Math.round(blockEntity.translateX * 100.0f / 5.0f) + 20, value -> {
            this.updateBlockEntity(be -> {
                be.translateX = (float)(value - 20) * 5.0f / 100.0f;
            });
            return "TX " + (value - 20) * 5 + "cm";
        }))), (int)20, (int)60, (int)((this.f_96543_ - 40) / 3));
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)new WidgetSlider(40, Math.round(blockEntity.translateY * 100.0f / 5.0f) + 20, value -> {
            this.updateBlockEntity(be -> {
                be.translateY = (float)(value - 20) * 5.0f / 100.0f;
            });
            return "TY " + (value - 20) * 5 + "cm";
        }))), (int)(20 + (this.f_96543_ - 40) / 3), (int)60, (int)((this.f_96543_ - 40) / 3));
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)new WidgetSlider(40, Math.round(blockEntity.translateZ * 100.0f / 5.0f) + 20, value -> {
            this.updateBlockEntity(be -> {
                be.translateZ = (float)(value - 20) * 5.0f / 100.0f;
            });
            return "TZ " + (value - 20) * 5 + "cm";
        }))), (int)(20 + (this.f_96543_ - 40) / 3 * 2), (int)60, (int)((this.f_96543_ - 40) / 3));
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)new WidgetSlider(36, (int)Math.round(Math.toDegrees(blockEntity.rotateX) / 5.0) + 18, value -> {
            this.updateBlockEntity(be -> {
                be.rotateX = (float)Math.toRadians((float)(value - 18) * 5.0f);
            });
            return "RX " + (value - 18) * 5 + "\u00b0";
        }))), (int)20, (int)80, (int)((this.f_96543_ - 40) / 3));
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)new WidgetSlider(36, (int)Math.round(Math.toDegrees(blockEntity.rotateY) / 5.0) + 18, value -> {
            this.updateBlockEntity(be -> {
                be.rotateY = (float)Math.toRadians((float)(value - 18) * 5.0f);
            });
            return "RY " + (value - 18) * 5 + "\u00b0";
        }))), (int)(20 + (this.f_96543_ - 40) / 3), (int)80, (int)((this.f_96543_ - 40) / 3));
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)new WidgetSlider(36, (int)Math.round(Math.toDegrees(blockEntity.rotateZ) / 5.0) + 18, value -> {
            this.updateBlockEntity(be -> {
                be.rotateZ = (float)Math.toRadians((float)(value - 18) * 5.0f);
            });
            return "RZ " + (value - 18) * 5 + "\u00b0";
        }))), (int)(20 + (this.f_96543_ - 40) / 3 * 2), (int)80, (int)((this.f_96543_ - 40) / 3));
        ((WidgetBetterCheckbox)this.m_142416_((GuiEventListener)new WidgetBetterCheckbox(20, 120, 160, 20, (Component)Text.translatable((String)"gui.mtrsteamloco.eye_candy.full_light", (Object[])new Object[0]), checked -> this.updateBlockEntity(be -> {
            be.fullLight = checked;
        })))).setChecked(blockEntity.fullLight);
        IDrawing.setPositionAndWidth((AbstractWidget)((AbstractWidget)this.m_142416_((GuiEventListener)UtilitiesClient.newButton((Component)Text.literal((String)"X"), sender -> this.m_7379_()))), (int)(this.f_96543_ - 40), (int)(this.f_96544_ - 40), (int)20);
    }

    private void updateBlockEntity(Consumer<BlockEyeCandy.BlockEntityEyeCandy> modifier) {
        this.getBlockEntity().ifPresent(blockEntity -> {
            modifier.accept((BlockEyeCandy.BlockEntityEyeCandy)((Object)blockEntity));
            PacketUpdateBlockEntity.sendUpdateC2S((BlockEntityMapper)blockEntity);
        });
    }

    private Optional<BlockEyeCandy.BlockEntityEyeCandy> getBlockEntity() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return Optional.empty();
        }
        return level.m_141902_(this.editingBlockPos, (BlockEntityType)Main.BLOCK_ENTITY_TYPE_EYE_CANDY.get());
    }

    public void m_7379_() {
        if (this.isSelectingModel) {
            this.isSelectingModel = false;
            this.loadPage();
        } else {
            this.f_96541_.m_91152_(null);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

