/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.gui;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forge.cn.zbx1425.mtrsteamloco.ClientConfig;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.AbstractScriptContext;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.ScriptContextManager;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.ScriptHolder;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.util.GraphicsTexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScriptDebugOverlay {
    public static void render(PoseStack vdStuff) {
        PoseStack matrices = vdStuff;
        if (!ClientConfig.enableScriptDebugOverlay) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_252880_(10.0f, 10.0f, 0.0f);
        HashMap<ScriptHolder, List> contexts = new HashMap<ScriptHolder, List>();
        for (Map.Entry<AbstractScriptContext, ScriptHolder> entry : ScriptContextManager.livingContexts.entrySet()) {
            contexts.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        int y = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        int lineHeight = Mth.m_14167_((float)(9.0f * 1.2f));
        for (Map.Entry entry : contexts.entrySet()) {
            ScriptHolder holder = (ScriptHolder)entry.getKey();
            if (holder.failTime > 0L) {
                ScriptDebugOverlay.drawText(vdStuff, font, holder.name + " FAILED", 0, y, -65536);
                y += lineHeight;
                for (String msgLine : Splitter.fixedLength((int)60).split((CharSequence)holder.failException.getMessage())) {
                    ScriptDebugOverlay.drawText(vdStuff, font, msgLine, 5, y, -30584);
                    y += lineHeight;
                }
            } else {
                ScriptDebugOverlay.drawText(vdStuff, font, holder.name, 0, y, -5592321);
                y += lineHeight;
            }
            for (AbstractScriptContext context : (List)entry.getValue()) {
                ScriptDebugOverlay.drawText(vdStuff, font, String.format("#%08X (%.2f ms)", context.hashCode(), (double)context.lastExecuteDuration / 1000.0), 10, y, -3355393);
                y += lineHeight;
                for (Map.Entry<String, Object> debugInfo : context.debugInfo.entrySet()) {
                    Object value = debugInfo.getValue();
                    if (value instanceof GraphicsTexture) {
                        GraphicsTexture texture = (GraphicsTexture)value;
                        float scale = (float)(Minecraft.m_91087_().m_91268_().m_85445_() - 40) / (float)texture.width;
                        ScriptDebugOverlay.blit(vdStuff, texture.identifier, 20, y, (int)((float)texture.width * scale), (int)((float)texture.height * scale));
                        ScriptDebugOverlay.drawText(vdStuff, font, debugInfo.getKey() + ": GraphicsTexture", 20, y, -1);
                        y += (int)((float)texture.height * scale) + lineHeight / 2;
                        continue;
                    }
                    ScriptDebugOverlay.drawText(vdStuff, font, debugInfo.getKey() + ": " + debugInfo.getValue(), 20, y, -1);
                    y += lineHeight;
                }
            }
        }
        matrices.m_85849_();
    }

    private static void drawText(PoseStack matrices, Font font, String text, int x, int y, int color) {
        font.m_92750_(matrices, text, (float)x, (float)y, color);
    }

    private static void blit(PoseStack matrices, ResourceLocation texture, int x, int y, int width, int height) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93160_((PoseStack)matrices, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
    }
}

