/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.cn.zbx1425.mtrsteamloco.CustomResources;
import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.mtrsteamloco.gui.ErrorScreen;
import forge.cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import forge.cn.zbx1425.sowcer.ContextCapability;
import forge.cn.zbx1425.sowcer.util.GlStateTracker;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={mtr.client.CustomResources.class})
public class CustomResourcesMixin {
    @Unique
    private static String capturedTextureId = "";
    @Unique
    private static boolean capturedFlipV = false;
    @Unique
    private static boolean captureBbModelPreload = false;

    @Inject(at={@At(value="HEAD")}, method={"reload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"})
    private static void reloadHead(ResourceManager manager, CallbackInfo ci) {
        ContextCapability.checkContextVersion();
        String glVersionStr = "OpenGL " + ContextCapability.contextVersion / 10 + "." + ContextCapability.contextVersion % 10;
        Main.LOGGER.info("NTE detected " + glVersionStr + (ContextCapability.isGL4ES ? " (GL4ES)." : "."));
        GlStateTracker.capture();
        MtrModelRegistryUtil.loadingErrorList.clear();
        MtrModelRegistryUtil.resourceManager = manager;
        CustomResources.reset(manager);
        Main.LOGGER.info("MTR has started loading custom resources. (including MTR-NTE train models and optimizations)");
    }

    @Inject(at={@At(value="TAIL")}, method={"reload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"})
    private static void reloadTail(ResourceManager manager, CallbackInfo ci) {
        CustomResources.resetTrainComponents();
        if (!MtrModelRegistryUtil.loadingErrorList.isEmpty()) {
            Minecraft.m_91087_().m_91152_(ErrorScreen.createScreen(MtrModelRegistryUtil.loadingErrorList, Minecraft.m_91087_().f_91080_));
        }
        GlStateTracker.restore();
        Main.LOGGER.info("MTR-NTE has finished loading custom resources.");
    }

    @Inject(at={@At(value="HEAD")}, method={"readResource"}, cancellable=true)
    private static void readResource(ResourceManager manager, String path, Consumer<JsonObject> callback, CallbackInfo ci) {
        if (path.toLowerCase(Locale.ROOT).endsWith(".obj") || path.contains("|")) {
            JsonObject dummyBbData = MtrModelRegistryUtil.createDummyBbDataPack(path, capturedTextureId, capturedFlipV, captureBbModelPreload);
            callback.accept(dummyBbData);
            return;
        }
        ResourceLocation location = new ResourceLocation(path);
        try {
            UtilitiesClient.getResources((ResourceManager)manager, (ResourceLocation)location).forEach(resource -> {
                try (InputStream stream = Utilities.getInputStream((Resource)resource);){
                    JsonObject modelObject = new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject();
                    if (path.toLowerCase(Locale.ROOT).endsWith(".bbmodel")) {
                        JsonObject dummyBbData = MtrModelRegistryUtil.createDummyBbDataPack(path, capturedTextureId, capturedFlipV, captureBbModelPreload);
                        modelObject.add("dummyBbData", (JsonElement)dummyBbData);
                    }
                    callback.accept(modelObject);
                }
                catch (Exception e) {
                    Main.LOGGER.error("On behalf of MTR: Parsing JSON " + path, (Throwable)e);
                }
                try {
                    Utilities.closeResource((Resource)resource);
                }
                catch (IOException e) {
                    Main.LOGGER.error("On behalf of MTR: Closing resource " + path, (Throwable)e);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        ci.cancel();
    }

    @Inject(at={@At(value="RETURN")}, method={"getOrDefault"}, remap=false, cancellable=true)
    private static <T> void getOrDefault(JsonObject jsonObject, String key, T defaultValue, Function<JsonElement, T> function, CallbackInfoReturnable<T> cir) {
        if (key.equals("texture_id")) {
            capturedTextureId = jsonObject.has(key) ? jsonObject.get(key).getAsString() : defaultValue.toString();
            capturedFlipV = jsonObject.has("flipV") && jsonObject.get("flipV").getAsBoolean();
            captureBbModelPreload = jsonObject.has("preloadBbModel") && jsonObject.get("preloadBbModel").getAsBoolean();
        } else if (key.equals("base_train_type") && jsonObject.has("base_type")) {
            cir.setReturnValue((Object)"$NTE_DUMMY_BLANK_PROPERTY");
        }
    }
}

