/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.cn.zbx1425.mtrsteamloco.ClientConfig;
import forge.cn.zbx1425.mtrsteamloco.MainClient;
import forge.cn.zbx1425.mtrsteamloco.render.RailPicker;
import forge.cn.zbx1425.mtrsteamloco.render.RenderUtil;
import forge.cn.zbx1425.mtrsteamloco.render.rail.RailRenderDispatcher;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.ScriptContextManager;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.util.GlStateTracker;
import forge.cn.zbx1425.sowcerext.model.integration.BufferSourceProxy;
import mtr.data.Rail;
import mtr.entity.EntitySeat;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderTrains.class})
public class RenderTrainsMixin {
    @Inject(at={@At(value="HEAD")}, method={"render(Lmtr/entity/EntitySeat;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"})
    private static void renderHead(EntitySeat entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo ci) {
        Minecraft.m_91087_().f_91073_.m_46473_().m_6182_("MTRRailwayData");
        RenderUtil.commonVertexConsumers = vertexConsumers;
        RenderUtil.commonPoseStack = matrices;
        RenderUtil.updateElapsedTicks();
    }

    @Inject(at={@At(value="TAIL")}, method={"render(Lmtr/entity/EntitySeat;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"})
    private static void renderTail(EntitySeat entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, CallbackInfo ci) {
        Minecraft.m_91087_().f_91073_.m_46473_().m_6182_("NTERailwayData");
        Matrix4f viewMatrix = new Matrix4f(matrices.m_85850_().m_252922_());
        MainClient.railRenderDispatcher.prepareDraw();
        if (ClientConfig.getRailRenderLevel() >= 2) {
            GlStateTracker.capture();
            MainClient.railRenderDispatcher.drawRails((Level)Minecraft.m_91087_().f_91073_, MainClient.drawScheduler.batchManager, viewMatrix);
            MainClient.drawScheduler.commitRaw(MainClient.drawContext);
            GlStateTracker.restore();
            if (Minecraft.m_91087_().m_91290_().m_114377_() && !Minecraft.m_91087_().m_91299_()) {
                MainClient.railRenderDispatcher.drawBoundingBoxes(matrices, vertexConsumers.m_6299_(RenderType.m_110504_()));
            }
            MainClient.railRenderDispatcher.drawRailNodes((Level)Minecraft.m_91087_().f_91073_, MainClient.drawScheduler, viewMatrix);
        }
        MainClient.drawContext.drawWithBlaze = !ClientConfig.useRenderOptimization();
        MainClient.drawContext.sortTranslucentFaces = ClientConfig.translucentSort;
        BufferSourceProxy vertexConsumersProxy = new BufferSourceProxy(vertexConsumers);
        MainClient.drawScheduler.commit(vertexConsumersProxy, MainClient.drawContext);
        vertexConsumersProxy.commit();
        if (Minecraft.m_91087_().f_91074_ != null && RailRenderDispatcher.isHoldingBrush) {
            RailPicker.pick();
            RailPicker.render(matrices, vertexConsumers);
        } else {
            RailPicker.pickedRail = null;
        }
        ScriptContextManager.disposeDeadContexts();
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"renderRailStandard(Lnet/minecraft/world/level/Level;Lmtr/data/Rail;FZFLjava/lang/String;FFFF)V"})
    private static void renderRailStandard(Level world, Rail rail, float yOffset, boolean renderColors, float railWidth, String texture, float u1, float v1, float u2, float v2, CallbackInfo ci) {
        boolean railAccepted;
        if (ClientConfig.getRailRenderLevel() == 0) {
            ci.cancel();
            return;
        }
        if (ClientConfig.getRailRenderLevel() >= 2 && (railAccepted = MainClient.railRenderDispatcher.registerRail(rail))) {
            ci.cancel();
        }
    }
}

