/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.network;

import forge.cn.zbx1425.mtrsteamloco.data.RailExtraSupplier;
import forge.cn.zbx1425.mtrsteamloco.mixin.RailwayDataAccessor;
import io.netty.buffer.Unpooled;
import java.util.Map;
import mtr.Registry;
import mtr.RegistryClient;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.packet.IPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class PacketUpdateRail {
    public static ResourceLocation PACKET_UPDATE_RAIL = new ResourceLocation("mtrsteamloco", "update_rail");

    public static void sendUpdateC2S(Rail newState, BlockPos posStart, BlockPos posEnd) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130085_(Minecraft.m_91087_().f_91073_.m_46472_().m_135782_());
        packet.m_130064_(posStart);
        packet.m_130064_(posEnd);
        newState.writePacket(packet);
        RegistryClient.sendToServer((ResourceLocation)PACKET_UPDATE_RAIL, (FriendlyByteBuf)packet);
    }

    public static void receiveUpdateC2S(MinecraftServer server, ServerPlayer player, FriendlyByteBuf packet) {
        ResourceKey levelKey = packet.m_236801_(Registries.f_256858_);
        BlockPos posStart = packet.m_130135_();
        BlockPos posEnd = packet.m_130135_();
        RailExtraSupplier extraTarget = (RailExtraSupplier)new Rail(packet);
        server.execute(() -> {
            ServerLevel level = server.m_129880_(levelKey);
            if (level == null) {
                return;
            }
            RailwayData railwayData = RailwayData.getInstance((Level)level);
            Map<BlockPos, Map<BlockPos, Rail>> rails = ((RailwayDataAccessor)railwayData).getRails();
            Rail railForward = rails.get(posStart).get(posEnd);
            Rail railBackward = rails.get(posEnd).get(posStart);
            if (railForward == null || railBackward == null) {
                return;
            }
            RailExtraSupplier extraForward = (RailExtraSupplier)railForward;
            RailExtraSupplier extraBackward = (RailExtraSupplier)railBackward;
            extraForward.setModelKey(extraTarget.getModelKey());
            extraBackward.setModelKey(extraTarget.getModelKey());
            extraForward.setVerticalCurveRadius(extraTarget.getVerticalCurveRadius());
            extraBackward.setVerticalCurveRadius(extraTarget.getVerticalCurveRadius());
            extraForward.setRenderReversed(extraTarget.getRenderReversed());
            extraBackward.setRenderReversed(!extraTarget.getRenderReversed());
            FriendlyByteBuf outboundPacket = new FriendlyByteBuf(Unpooled.buffer());
            outboundPacket.m_130070_(railForward.transportMode.toString());
            outboundPacket.m_130064_(posStart);
            outboundPacket.m_130064_(posEnd);
            railForward.writePacket(outboundPacket);
            railBackward.writePacket(outboundPacket);
            outboundPacket.writeLong(0L);
            for (ServerPlayer levelPlayer : level.m_6907_()) {
                Registry.sendToPlayer((ServerPlayer)levelPlayer, (ResourceLocation)IPacket.PACKET_CREATE_RAIL, (FriendlyByteBuf)outboundPacket);
            }
        });
    }
}

