/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.cn.zbx1425.mtrsteamloco.ClientConfig;
import forge.cn.zbx1425.mtrsteamloco.MainClient;
import mtr.MTRClient;
import mtr.data.TrainClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;

public class RenderUtil {
    public static PoseStack commonPoseStack = null;
    public static MultiBufferSource commonVertexConsumers = null;
    public static double runningSeconds;
    public static double frameSeconds;
    private static float lastRenderedTick;

    public static void updateElapsedTicks() {
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        float ticksElapsed = Minecraft.m_91087_().m_91104_() || lastRenderedTick == MTRClient.getGameTick() ? 0.0f : lastFrameDuration;
        lastRenderedTick = MTRClient.getGameTick();
        frameSeconds = (double)ticksElapsed / 20.0;
        runningSeconds += frameSeconds;
    }

    public static boolean shouldSkipRenderTrain(TrainClient train) {
        LocalPlayer player;
        if (!ClientConfig.enableTrainRender) {
            return true;
        }
        if (ClientConfig.hideRidingTrain && (player = Minecraft.m_91087_().f_91074_) != null) {
            return train.isPlayerRiding((Player)player);
        }
        return false;
    }

    public static String getRenderStatusMessage() {
        return "\n=== NTE Rendering Status ===\nDraw Calls: " + MainClient.drawContext.drawCallCount + ", Batches: " + MainClient.drawContext.batchCount + "\nFaces: " + MainClient.drawContext.singleFaceCount + " non-instanced, " + MainClient.drawContext.instancedFaceCount + " instanced, " + (MainClient.drawContext.singleFaceCount + MainClient.drawContext.instancedFaceCount) + " total\nFaces via Blaze3D: " + MainClient.drawContext.blazeFaceCount + "\nUploaded Models: " + MainClient.modelManager.uploadedVertArrays.size() + " (" + MainClient.modelManager.vaoCount + " VAOs, " + MainClient.modelManager.vboCount + " VBOs)\n" + String.join((CharSequence)"\n", MainClient.drawContext.debugInfo);
    }

    public static int parseHexColor(String src) {
        if (src.length() > 6) {
            return Integer.reverseBytes(Integer.parseInt(src, 16));
        }
        return Integer.reverseBytes(Integer.parseInt(src, 16) << 8 | 0xFF);
    }

    public static void displayStatusMessage(String msg) {
    }

    static {
        lastRenderedTick = 0.0f;
    }
}

