/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.cn.zbx1425.mtrsteamloco.mixin.ModelPartAccessor;
import forge.cn.zbx1425.sowcer.batch.MaterialProp;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcerext.model.Face;
import forge.cn.zbx1425.sowcerext.model.RawMesh;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import forge.cn.zbx1425.sowcerext.model.Vertex;
import java.util.Arrays;
import java.util.stream.IntStream;
import mtr.model.ModelTrainBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CapturingVertexConsumer
implements VertexConsumer {
    RawModel[] models = new RawModel[5];
    RawMesh[] buildingMeshes = new RawMesh[5];
    Vertex buildingVertex = new Vertex();

    public CapturingVertexConsumer() {
        Arrays.setAll(this.models, ignored -> new RawModel());
    }

    public void captureModelPart(ModelPart modelPart) {
        CapturingVertexConsumer.dumpModelPartQuads(modelPart, new PoseStack(), this, 0, 0);
    }

    public static void dumpModelPartQuads(ModelPart modelPart, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
        if (!(!modelPart.f_104207_ || ((ModelPartAccessor)modelPart).getCubes().isEmpty() && ((ModelPartAccessor)modelPart).getChildren().isEmpty())) {
            poseStack.m_85836_();
            modelPart.m_104299_(poseStack);
            for (ModelPart.Cube cube : ((ModelPartAccessor)modelPart).getCubes()) {
                cube.m_171332_(poseStack.m_85850_(), vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            for (ModelPart child : ((ModelPartAccessor)modelPart).getChildren().values()) {
                CapturingVertexConsumer.dumpModelPartQuads(child, poseStack, vertexConsumer, packedLight, packedOverlay);
            }
            poseStack.m_85849_();
        }
    }

    public void beginStage(ResourceLocation texture, ModelTrainBase.RenderStage stage) {
        MaterialProp materialProp = new MaterialProp();
        materialProp.texture = texture;
        switch (stage) {
            case LIGHTS: {
                materialProp.shaderName = "rendertype_beacon_beam";
                materialProp.cutoutHack = true;
                break;
            }
            case ALWAYS_ON_LIGHTS: {
                materialProp.shaderName = "rendertype_beacon_beam";
                materialProp.translucent = true;
                materialProp.writeDepthBuf = false;
                break;
            }
            case EXTERIOR: {
                materialProp.shaderName = "rendertype_entity_cutout";
                break;
            }
            case INTERIOR: {
                materialProp.shaderName = "rendertype_entity_cutout";
                materialProp.attrState.setLightmapUV(0xF000F0);
                break;
            }
            case INTERIOR_TRANSLUCENT: {
                materialProp.shaderName = "rendertype_entity_translucent_cull";
                materialProp.translucent = true;
                materialProp.attrState.setLightmapUV(0xF000F0);
            }
        }
        for (int i = 0; i < this.models.length; ++i) {
            this.buildingMeshes[i] = this.models[i].meshList.computeIfAbsent(materialProp, RawMesh::new);
        }
    }

    public void reset() {
        Arrays.setAll(this.models, ignored -> new RawModel());
        Arrays.fill(this.buildingMeshes, null);
        this.buildingVertex = new Vertex();
    }

    @NotNull
    public VertexConsumer m_5483_(double x, double y, double z) {
        this.buildingVertex.position = new Vector3f((float)x, (float)y, (float)z);
        return this;
    }

    @NotNull
    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        return this;
    }

    @NotNull
    public VertexConsumer m_7421_(float u, float v) {
        this.buildingVertex.u = u;
        this.buildingVertex.v = v;
        return this;
    }

    @NotNull
    public VertexConsumer m_7122_(int u, int v) {
        return this;
    }

    @NotNull
    public VertexConsumer m_7120_(int u, int v) {
        return this;
    }

    @NotNull
    public VertexConsumer m_5601_(float x, float y, float z) {
        this.buildingVertex.normal = new Vector3f(x, y, z);
        return this;
    }

    public void m_5752_() {
        int meshToUse;
        if (Math.abs(this.buildingVertex.position.z()) > 1024.0f) {
            boolean xSign = this.buildingVertex.position.x() > 0.0f;
            boolean zSign = this.buildingVertex.position.z() > 0.0f;
            meshToUse = (xSign ? 0 : 2) + (zSign ? 0 : 1) + 1;
            this.buildingVertex.position.add(new Vector3f(0.0f, 0.0f, zSign ? -2048.0f : 2048.0f));
        } else {
            meshToUse = 0;
        }
        RawMesh buildingMesh = this.buildingMeshes[meshToUse];
        buildingMesh.vertices.add(this.buildingVertex);
        if (buildingMesh.vertices.size() % 4 == 0) {
            buildingMesh.faces.add(new Face(IntStream.range(buildingMesh.vertices.size() - 4, buildingMesh.vertices.size()).toArray()));
        }
        this.buildingVertex = new Vertex();
    }

    public void m_7404_(int defaultR, int defaultG, int defaultB, int defaultA) {
    }

    public void m_141991_() {
    }
}

