/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.rail;

import forge.cn.zbx1425.mtrsteamloco.data.RailExtraSupplier;
import forge.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import forge.cn.zbx1425.mtrsteamloco.render.rail.RailRenderDispatcher;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.util.AttrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import mtr.data.Rail;
import net.minecraft.util.Mth;

public class BakedRail {
    public HashMap<Long, ArrayList<Matrix4f>> coveredChunks = new HashMap();
    public static final int POS_SHIFT = 1;
    public String modelKey;
    public int color;

    public BakedRail(Rail rail) {
        this.modelKey = RailRenderDispatcher.getModelKeyForRender(rail);
        this.color = AttrUtil.argbToBgr(rail.railType.color | 0xFF000000);
        if (!this.modelKey.equals("null")) {
            boolean reverse = ((RailExtraSupplier)rail).getRenderReversed();
            float interval = RailModelRegistry.getProperty((String)this.modelKey).repeatInterval;
            float yOffset = RailModelRegistry.getProperty((String)this.modelKey).yOffset;
            rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
                float xc = (float)((x1 + x4) / 2.0);
                float yc = (float)((y1 + y2) / 2.0);
                float zc = (float)((z1 + z4) / 2.0);
                this.coveredChunks.computeIfAbsent(BakedRail.chunkIdFromWorldPos(Mth.m_14143_((float)xc), Mth.m_14143_((float)zc)), ignored -> new ArrayList()).add(BakedRail.getLookAtMat(xc, yc + yOffset, zc, (float)x4, (float)y2 + yOffset, (float)z4, interval, reverse));
            }, 0.0f, 0.0f);
        }
    }

    public static long chunkIdFromWorldPos(float bpX, float bpZ) {
        return (long)((int)bpX >> 5) << 32 | (long)((int)bpZ >> 5) & 0xFFFFFFFFL;
    }

    public static long chunkIdFromSectPos(int spX, int spZ) {
        return (long)(spX >> 1) << 32 | (long)(spZ >> 1) & 0xFFFFFFFFL;
    }

    public static Matrix4f getLookAtMat(float posX, float posY, float posZ, float tgX, float tgY, float tgZ, float len, boolean reverse) {
        Matrix4f matrix4f = Matrix4f.translation(posX, posY, posZ);
        float yaw = (float)Mth.m_14136_((double)(tgX - posX), (double)(tgZ - posZ));
        float pitch = (float)Mth.m_14136_((double)(tgY - posY), (double)(len / 2.0f));
        matrix4f.rotateY((reverse ? (float)Math.PI : 0.0f) + yaw);
        matrix4f.rotateX(reverse ? pitch : -pitch);
        return matrix4f;
    }
}

