/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.rail;

import forge.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import forge.cn.zbx1425.mtrsteamloco.render.rail.BakedRail;
import forge.cn.zbx1425.mtrsteamloco.render.rail.RailChunkBase;
import forge.cn.zbx1425.mtrsteamloco.render.rail.RailRenderDispatcher;
import forge.cn.zbx1425.sowcer.batch.BatchManager;
import forge.cn.zbx1425.sowcer.batch.EnqueueProp;
import forge.cn.zbx1425.sowcer.batch.ShaderProp;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcer.model.Model;
import forge.cn.zbx1425.sowcer.model.VertArrays;
import forge.cn.zbx1425.sowcer.vertex.VertAttrMapping;
import forge.cn.zbx1425.sowcer.vertex.VertAttrSrc;
import forge.cn.zbx1425.sowcer.vertex.VertAttrState;
import forge.cn.zbx1425.sowcer.vertex.VertAttrType;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class MeshBuildingRailChunk
extends RailChunkBase {
    private final RawModel railModel;
    private Model uploadedCombinedModel;
    private VertArrays vertArrays;
    private static final VertAttrMapping RAIL_MAPPING = new VertAttrMapping.Builder().set(VertAttrType.POSITION, VertAttrSrc.VERTEX_BUF).set(VertAttrType.COLOR, VertAttrSrc.VERTEX_BUF_OR_GLOBAL).set(VertAttrType.UV_TEXTURE, VertAttrSrc.VERTEX_BUF).set(VertAttrType.UV_OVERLAY, VertAttrSrc.GLOBAL).set(VertAttrType.UV_LIGHTMAP, VertAttrSrc.VERTEX_BUF_OR_GLOBAL).set(VertAttrType.NORMAL, VertAttrSrc.VERTEX_BUF).set(VertAttrType.MATRIX_MODEL, VertAttrSrc.GLOBAL).build();

    protected MeshBuildingRailChunk(Long chunkId, String modelKey) {
        super(chunkId, modelKey);
        this.railModel = RailModelRegistry.getProperty((String)modelKey).rawModel;
    }

    @Override
    public void rebuildBuffer(Level world) {
        super.rebuildBuffer(world);
        if (this.railModel == null) {
            return;
        }
        float yMin = 256.0f;
        float yMax = -64.0f;
        RawModel combinedModel = new RawModel();
        for (Map.Entry entry : this.containingRails.entrySet()) {
            ArrayList railSpan = (ArrayList)entry.getValue();
            for (Matrix4f pieceMat : railSpan) {
                Vector3f lightPos = pieceMat.getTranslationPart();
                yMin = Math.min(yMin, lightPos.y());
                yMax = Math.max(yMax, lightPos.y());
                BlockPos lightBlockPos = new BlockPos(Mth.m_14143_((float)lightPos.x()), Mth.m_14107_((double)((double)lightPos.y() + 0.1)), Mth.m_14143_((float)lightPos.z()));
                int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, lightBlockPos), (int)world.m_45517_(LightLayer.SKY, lightBlockPos));
                combinedModel.appendTransformed(this.railModel, pieceMat, ((BakedRail)entry.getKey()).color, light);
            }
        }
        if (this.vertArrays != null) {
            this.vertArrays.close();
        }
        if (this.uploadedCombinedModel != null) {
            this.uploadedCombinedModel.close();
        }
        this.uploadedCombinedModel = combinedModel.upload(RAIL_MAPPING);
        this.vertArrays = VertArrays.createAll(this.uploadedCombinedModel, RAIL_MAPPING, null);
        if (yMin > yMax) {
            yMin = yMax;
        }
        this.setBoundingBox(yMin, yMax);
    }

    @Override
    public void enqueue(BatchManager batchManager, ShaderProp shaderProp) {
        if (this.railModel == null) {
            return;
        }
        if (this.vertArrays == null) {
            return;
        }
        VertAttrState attrState = new VertAttrState().setModelMatrix(shaderProp.viewMatrix).setOverlayUVNoOverlay();
        if (!RailRenderDispatcher.isHoldingRailItem) {
            attrState.setColor(-1);
        }
        batchManager.enqueue(this.vertArrays, new EnqueueProp(attrState), ShaderProp.DEFAULT);
    }

    @Override
    public void close() {
        if (this.vertArrays != null) {
            this.vertArrays.close();
        }
        if (this.uploadedCombinedModel != null) {
            this.uploadedCombinedModel.close();
        }
    }
}

