/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.rail;

import forge.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import forge.cn.zbx1425.mtrsteamloco.render.rail.BakedRail;
import forge.cn.zbx1425.sowcer.batch.BatchManager;
import forge.cn.zbx1425.sowcer.batch.ShaderProp;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class RailChunkBase
implements Closeable {
    public Long chunkId;
    public AABB boundingBox;
    public HashMap<BakedRail, ArrayList<Matrix4f>> containingRails = new HashMap();
    public final String modelKey;
    protected float modelYMin;
    protected float modelYMax;
    public boolean isDirty = false;
    public boolean bufferBuilt = false;
    public double cameraDistManhattanXZ = 0.0;

    public RailChunkBase(long chunkId, String modelKey) {
        this.chunkId = chunkId;
        this.modelKey = modelKey;
        long boundary = RailModelRegistry.getProperty((String)modelKey).boundingBox;
        this.modelYMin = Float.intBitsToFloat((int)(boundary >> 32));
        this.modelYMax = Float.intBitsToFloat((int)(boundary & 0xFFFFFFFFL));
        this.setBoundingBox(0.0f, 0.0f);
    }

    protected void setBoundingBox(float yMin, float yMax) {
        int posXMin = (int)(this.chunkId >> 32) << 5;
        int posZMin = (int)(this.chunkId & 0xFFFFFFFFL) << 5;
        int span = 32;
        this.boundingBox = new AABB((double)posXMin, (double)(yMin + this.modelYMin - 1.0f), (double)posZMin, (double)(posXMin + span), (double)(yMax + this.modelYMax + 1.0f), (double)(posZMin + span));
    }

    public boolean isEven() {
        return ((int)(this.chunkId >> 32) + (int)(this.chunkId & 0xFFFFFFFFL)) % 2 == 0;
    }

    public ChunkPos getChunkPos() {
        return new ChunkPos((int)(this.chunkId >> 32) << 1, (int)(this.chunkId & 0xFFFFFFFFL) << 1);
    }

    public boolean containsYSection(int yMin, int yMax) {
        return (double)(yMin << 4) < this.boundingBox.f_82289_ || (double)(yMax << 4) > this.boundingBox.f_82292_;
    }

    public double getCameraDistManhattanXZ(Vec3 cameraPos) {
        this.cameraDistManhattanXZ = Math.abs(cameraPos.f_82479_ - (this.boundingBox.f_82288_ + this.boundingBox.f_82291_) / 2.0) + Math.abs(cameraPos.f_82481_ - (this.boundingBox.f_82290_ + this.boundingBox.f_82293_) / 2.0);
        return this.cameraDistManhattanXZ;
    }

    public void addRail(BakedRail rail) {
        this.containingRails.put(rail, rail.coveredChunks.get(this.chunkId));
        this.isDirty = true;
    }

    public void removeRail(BakedRail rail) {
        this.containingRails.remove(rail);
        this.isDirty = true;
    }

    public void rebuildBuffer(Level world) {
        this.isDirty = false;
        this.bufferBuilt = true;
    }

    public abstract void enqueue(BatchManager var1, ShaderProp var2);

    @Override
    public void close() {
    }
}

