/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.rail;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.cn.zbx1425.mtrsteamloco.ClientConfig;
import forge.cn.zbx1425.mtrsteamloco.data.RailExtraSupplier;
import forge.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import forge.cn.zbx1425.mtrsteamloco.gui.SelectListScreen;
import forge.cn.zbx1425.mtrsteamloco.mixin.LevelRendererAccessor;
import forge.cn.zbx1425.mtrsteamloco.render.rail.BakedRail;
import forge.cn.zbx1425.mtrsteamloco.render.rail.InstancedRailChunk;
import forge.cn.zbx1425.mtrsteamloco.render.rail.MeshBuildingRailChunk;
import forge.cn.zbx1425.mtrsteamloco.render.rail.RailChunkBase;
import forge.cn.zbx1425.sowcer.batch.BatchManager;
import forge.cn.zbx1425.sowcer.batch.ShaderProp;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcerext.reuse.DrawScheduler;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mtr.Items;
import mtr.MTRClient;
import mtr.client.ClientData;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.TransportMode;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RailRenderDispatcher {
    private final HashMap<Rail, BakedRail> railRefMap = new HashMap();
    private final HashMap<String, HashMap<Long, RailChunkBase>> railChunkMap = new HashMap();
    private final List<RailChunkBase> railChunkList = new LinkedList<RailChunkBase>();
    private boolean isInstanced;
    private final HashSet<Rail> currentFrameRails = new HashSet();
    public static boolean isHoldingRailItem = false;
    public static boolean isHoldingBrush = false;
    public static boolean isHoldingRailItemOrBrush = false;
    public static boolean isPreviewingModel = false;

    private void addRail(Rail rail) {
        if (this.railRefMap.containsKey(rail)) {
            return;
        }
        BakedRail bakedRail = new BakedRail(rail);
        this.railRefMap.put(rail, bakedRail);
        HashMap<Long, RailChunkBase> chunkMap = this.railChunkMap.get(bakedRail.modelKey);
        if (chunkMap == null) {
            return;
        }
        for (long chunkId : bakedRail.coveredChunks.keySet()) {
            if (chunkMap.containsKey(chunkId)) {
                chunkMap.get(chunkId).addRail(bakedRail);
                continue;
            }
            RailChunkBase newChunk = this.isInstanced ? new InstancedRailChunk((Long)chunkId, bakedRail.modelKey) : new MeshBuildingRailChunk((Long)chunkId, bakedRail.modelKey);
            newChunk.addRail(bakedRail);
            chunkMap.put(chunkId, newChunk);
            this.railChunkList.add(newChunk);
        }
    }

    private void removeRail(Rail rail) {
        if (!this.railRefMap.containsKey(rail)) {
            return;
        }
        BakedRail bakedRail = this.railRefMap.get(rail);
        this.railRefMap.remove(rail);
        HashMap<Long, RailChunkBase> chunkMap = this.railChunkMap.get(bakedRail.modelKey);
        if (chunkMap == null) {
            return;
        }
        for (long chunkId : bakedRail.coveredChunks.keySet()) {
            chunkMap.get(chunkId).removeRail(bakedRail);
        }
    }

    public boolean registerRail(Rail rail) {
        if (RailRenderDispatcher.getModelKeyForRender(rail).isEmpty() || rail.railType == RailType.NONE) {
            return false;
        }
        this.currentFrameRails.add(rail);
        return true;
    }

    public void clearRail() {
        this.currentFrameRails.clear();
        this.railRefMap.clear();
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            for (RailChunkBase chunk : chunkMap.values()) {
                chunk.close();
            }
            chunkMap.clear();
        }
        this.railChunkMap.clear();
        this.railChunkList.clear();
        for (String key : RailModelRegistry.elements.keySet()) {
            this.railChunkMap.put(key, new HashMap());
        }
    }

    public void registerLightUpdate(int x, int yMin, int yMax, int z) {
        long chunkId = BakedRail.chunkIdFromSectPos(x, z);
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            RailChunkBase chunk = chunkMap.get(chunkId);
            if (chunk == null || chunk.isDirty || !chunk.containsYSection(yMin, yMax)) continue;
            chunk.isDirty = true;
        }
    }

    public void prepareDraw() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        boolean bl = isPreviewingModel = currentScreen instanceof SelectListScreen && ((SelectListScreen)currentScreen).isSelecting();
        if (!isPreviewingModel) {
            isHoldingRailItem = RenderTrains.isHoldingRailRelated((Player)Minecraft.m_91087_().f_91074_);
            isHoldingBrush = Utilities.isHolding((Player)Minecraft.m_91087_().f_91074_, item -> item.equals(Items.BRUSH.get()));
            isHoldingRailItemOrBrush = isHoldingRailItem || isHoldingBrush;
        } else {
            isHoldingRailItem = false;
            isHoldingBrush = false;
            isHoldingRailItemOrBrush = false;
        }
    }

    public void drawRails(Level level, BatchManager batchManager, Matrix4f viewMatrix) {
        boolean shouldBeInstanced;
        boolean bl = shouldBeInstanced = ClientConfig.getRailRenderLevel() == 3;
        if (this.isInstanced != shouldBeInstanced) {
            this.clearRail();
        }
        this.isInstanced = shouldBeInstanced;
        HashSet<Rail> railsToAdd = new HashSet<Rail>(this.currentFrameRails);
        railsToAdd.removeAll(this.railRefMap.keySet());
        for (Rail rail : railsToAdd) {
            this.addRail(rail);
        }
        HashSet<Rail> railsToRemove = new HashSet<Rail>(this.railRefMap.keySet());
        railsToRemove.removeAll(this.currentFrameRails);
        for (Rail rail : railsToRemove) {
            this.removeRail(rail);
        }
        this.currentFrameRails.clear();
        Vec3 vec3 = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        this.railChunkList.sort(Comparator.comparingDouble(chunk -> chunk.getCameraDistManhattanXZ(cameraBlockPos)));
        int buffersRebuilt = 0;
        Frustum cullingFrustum = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getCullingFrustum();
        ShaderProp shaderProp = new ShaderProp().setViewMatrix(viewMatrix);
        int maxRailDistance = MTRClient.isReplayMod() ? 1024 : UtilitiesClient.getRenderDistance() * 16;
        boolean isOutsideRenderDistance = false;
        Iterator<RailChunkBase> it = this.railChunkList.iterator();
        while (it.hasNext()) {
            RailChunkBase chunk2 = it.next();
            if (chunk2.containingRails.isEmpty()) {
                chunk2.close();
                it.remove();
                this.railChunkMap.get(chunk2.modelKey).remove(chunk2.chunkId);
                continue;
            }
            if (isOutsideRenderDistance) continue;
            if (chunk2.cameraDistManhattanXZ > (double)maxRailDistance) {
                isOutsideRenderDistance = true;
                continue;
            }
            if (chunk2.isDirty || !chunk2.bufferBuilt) {
                if (MTRClient.isReplayMod() || buffersRebuilt < 1) {
                    chunk2.rebuildBuffer(level);
                }
                ++buffersRebuilt;
            }
            if (!chunk2.bufferBuilt || !cullingFrustum.m_113029_(chunk2.boundingBox)) continue;
            chunk2.enqueue(batchManager, shaderProp);
        }
    }

    public void drawRailNodes(Level level, DrawScheduler drawScheduler, Matrix4f viewMatrix) {
        if (isHoldingRailItemOrBrush) {
            HashSet<BlockPos> drawnNodes = new HashSet<BlockPos>();
            for (Map.Entry entryStart : ClientData.RAILS.entrySet()) {
                for (Map.Entry entryEnd : ((Map)entryStart.getValue()).entrySet()) {
                    int light;
                    Matrix4f nodePose;
                    if (drawnNodes.add((BlockPos)entryStart.getKey())) {
                        nodePose = viewMatrix.copy();
                        nodePose.translate((float)((BlockPos)entryStart.getKey()).m_123341_() + 0.5f, ((BlockPos)entryStart.getKey()).m_123342_(), (float)((BlockPos)entryStart.getKey()).m_123343_() + 0.5f);
                        nodePose.rotateY(-((float)((Rail)entryEnd.getValue()).facingStart.angleRadians) + 1.5707964f);
                        light = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, (BlockPos)entryStart.getKey()), (int)level.m_45517_(LightLayer.SKY, (BlockPos)entryStart.getKey()));
                        drawScheduler.enqueue(RailModelRegistry.railNodeModel, nodePose, light);
                    }
                    if (!drawnNodes.add((BlockPos)entryEnd.getKey())) continue;
                    nodePose = viewMatrix.copy();
                    nodePose.translate((float)((BlockPos)entryEnd.getKey()).m_123341_() + 0.5f, ((BlockPos)entryEnd.getKey()).m_123342_(), (float)((BlockPos)entryEnd.getKey()).m_123343_() + 0.5f);
                    nodePose.rotateY(-((float)((Rail)entryEnd.getValue()).facingEnd.angleRadians) + 1.5707964f);
                    light = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, (BlockPos)entryEnd.getKey()), (int)level.m_45517_(LightLayer.SKY, (BlockPos)entryEnd.getKey()));
                    drawScheduler.enqueue(RailModelRegistry.railNodeModel, nodePose, light);
                }
            }
        }
    }

    public static String getModelKeyForRender(Rail rail) {
        String customModelKey = ((RailExtraSupplier)rail).getModelKey();
        if (customModelKey.equals("") || !RailModelRegistry.elements.containsKey(customModelKey)) {
            if (rail.transportMode == TransportMode.TRAIN) {
                if (rail.railType == RailType.SIDING) {
                    return "nte_builtin_depot";
                }
                return "nte_builtin_concrete_sleeper";
            }
            return "";
        }
        if (customModelKey.equals("null")) {
            return isHoldingRailItem ? "" : "null";
        }
        return customModelKey;
    }

    public void drawBoundingBoxes(PoseStack matrixStack, VertexConsumer buffer) {
        for (RailChunkBase chunk : this.railChunkList) {
            boolean isChunkEven = chunk.isEven();
            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer, (AABB)chunk.boundingBox, (float)1.0f, (float)(isChunkEven ? 1.0f : 0.0f), (float)(isChunkEven ? 0.0f : 1.0f), (float)1.0f);
        }
    }
}

