/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.scripting;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.mtrsteamloco.mixin.ClientCacheAccessor;
import forge.cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.util.GraphicsTexture;
import forge.cn.zbx1425.sowcerext.util.ResourceUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import javax.imageio.ImageIO;
import mtr.Keys;
import mtr.client.ClientData;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Context;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Scriptable;

public class ScriptResourceUtil {
    protected static Context activeContext;
    protected static Scriptable activeScope;
    private static final Stack<ResourceLocation> scriptLocationStack;
    private static final Logger LOGGER;
    private static final ResourceLocation NOTO_SANS_CJK_LOCATION;
    private static final ResourceLocation NOTO_SANS_LOCATION;
    private static final ResourceLocation NOTO_SERIF_LOCATION;
    private static boolean hasNotoSansCjk;
    private static final FontRenderContext FONT_CONTEXT;

    public static void init(ResourceManager resourceManager) {
        hasNotoSansCjk = UtilitiesClient.hasResource((ResourceLocation)NOTO_SANS_CJK_LOCATION);
    }

    public static void executeScript(Context rhinoCtx, Scriptable scope, ResourceLocation scriptLocation, String script) {
        scriptLocationStack.push(scriptLocation);
        rhinoCtx.evaluateString(scope, script, scriptLocation.toString(), 1, null);
        scriptLocationStack.pop();
    }

    public static void includeScript(Object pathOrIdentifier) throws IOException {
        if (activeContext == null) {
            throw new RuntimeException("Cannot use include in functions, as by that time NTE no longer processes scripts.");
        }
        ResourceLocation identifier = pathOrIdentifier instanceof ResourceLocation ? (ResourceLocation)pathOrIdentifier : ScriptResourceUtil.idRelative(pathOrIdentifier.toString());
        ScriptResourceUtil.executeScript(activeContext, activeScope, identifier, ResourceUtil.readResource(ScriptResourceUtil.manager(), identifier));
    }

    public static void print(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object.toString());
            sb.append(" ");
        }
        Main.LOGGER.info(sb.toString().trim());
    }

    public static ResourceManager manager() {
        return MtrModelRegistryUtil.resourceManager;
    }

    public static ResourceManager mgr() {
        return MtrModelRegistryUtil.resourceManager;
    }

    public static ResourceLocation identifier(String textForm) {
        return new ResourceLocation(textForm);
    }

    public static ResourceLocation id(String textForm) {
        return new ResourceLocation(textForm);
    }

    public static ResourceLocation idRelative(String textForm) {
        if (scriptLocationStack.empty()) {
            throw new RuntimeException("Cannot use idRelative in functions, as by that time NTE no longer knows which file it's coming from.");
        }
        return ResourceUtil.resolveRelativePath(scriptLocationStack.peek(), textForm, null);
    }

    public static ResourceLocation idr(String textForm) {
        if (scriptLocationStack.empty()) {
            throw new RuntimeException("Cannot use idr in functions, as by that time NTE no longer knows which file it's coming from.");
        }
        return ResourceUtil.resolveRelativePath(scriptLocationStack.peek(), textForm, null);
    }

    public static InputStream readStream(ResourceLocation identifier) throws IOException {
        List resources = UtilitiesClient.getResources((ResourceManager)ScriptResourceUtil.manager(), (ResourceLocation)identifier);
        if (resources.isEmpty()) {
            throw new FileNotFoundException(identifier.toString());
        }
        return Utilities.getInputStream((Resource)((Resource)resources.get(0)));
    }

    public static String readString(ResourceLocation identifier) {
        try {
            return ResourceUtil.readResource(ScriptResourceUtil.manager(), identifier);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Font getSystemFont(String fontName) {
        ClientCacheAccessor clientCache = (ClientCacheAccessor)ClientData.DATA_CACHE;
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        switch (fontName) {
            case "Noto Sans": {
                if (clientCache.getFont() == null || hasNotoSansCjk && !clientCache.getFont().canDisplay('\u8349')) {
                    try {
                        if (hasNotoSansCjk) {
                            clientCache.setFont(Font.createFont(0, Utilities.getInputStream((Optional)resourceManager.m_213713_(NOTO_SANS_CJK_LOCATION))));
                        } else {
                            clientCache.setFont(Font.createFont(0, Utilities.getInputStream((Optional)resourceManager.m_213713_(NOTO_SANS_LOCATION))));
                        }
                    }
                    catch (Exception ex) {
                        Main.LOGGER.warn("Failed loading font", (Throwable)ex);
                    }
                }
                return clientCache.getFont();
            }
            case "Noto Serif": {
                if (clientCache.getFontCjk() == null) {
                    try {
                        clientCache.setFontCjk(Font.createFont(0, Utilities.getInputStream((Optional)resourceManager.m_213713_(NOTO_SERIF_LOCATION))));
                    }
                    catch (Exception ex) {
                        Main.LOGGER.warn("Failed loading font", (Throwable)ex);
                    }
                }
                return clientCache.getFontCjk();
            }
        }
        return new Font(fontName, 0, 1);
    }

    public static FontRenderContext getFontRenderContext() {
        return FONT_CONTEXT;
    }

    public static AttributedString ensureStrFonts(String text, Font font) {
        AttributedString result = new AttributedString(text);
        if (text.isEmpty()) {
            return result;
        }
        result.addAttribute(TextAttribute.FONT, font, 0, text.length());
        for (int characterIndex = 0; characterIndex < text.length(); ++characterIndex) {
            char character = text.charAt(characterIndex);
            if (font.canDisplay(character)) continue;
            Font defaultFont = null;
            for (Font testFont : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                if (!testFont.canDisplay(character)) continue;
                defaultFont = testFont;
                break;
            }
            Font newFont = (defaultFont == null ? new Font(null) : defaultFont).deriveFont(font.getStyle(), font.getSize2D());
            result.addAttribute(TextAttribute.FONT, newFont, characterIndex, characterIndex + 1);
        }
        return result;
    }

    public static BufferedImage readBufferedImage(ResourceLocation identifier) throws IOException {
        try (InputStream is = ScriptResourceUtil.readStream(identifier);){
            BufferedImage bufferedImage = GraphicsTexture.createArgbBufferedImage(ImageIO.read(is));
            return bufferedImage;
        }
    }

    public static Font readFont(ResourceLocation identifier) throws IOException, FontFormatException {
        try (InputStream is = ScriptResourceUtil.readStream(identifier);){
            Font font = Font.createFont(0, is);
            return font;
        }
    }

    public static int getParticleTypeId(ResourceLocation identifier) {
        Optional particleType = BuiltInRegistries.f_257034_.m_6612_(identifier);
        return particleType.map(arg_0 -> ((Registry)BuiltInRegistries.f_257034_).m_7447_(arg_0)).orElse(-1);
    }

    public static CompoundTag parseNbtString(String text) throws CommandSyntaxException {
        return TagParser.m_129359_((String)text);
    }

    public static String getMTRVersion() {
        String mtrModVersion;
        try {
            mtrModVersion = (String)Keys.class.getField("MOD_VERSION").get(null);
        }
        catch (ReflectiveOperationException ignored) {
            mtrModVersion = "0.0.0-0.0.0";
        }
        return mtrModVersion;
    }

    public static String getNTEVersion() {
        return "0.5.1+1.19.4";
    }

    public static int getNTEVersionInt() {
        int[] components = Arrays.stream("0.5.1+1.19.4".split("\\+", 2)[0].split("\\.", 3)).mapToInt(Integer::parseInt).toArray();
        return components[0] * 10000 + components[1] * 100 + components[2];
    }

    public static int getNTEProtoVersion() {
        return 2;
    }

    static {
        scriptLocationStack = new Stack();
        LOGGER = LoggerFactory.getLogger((String)"MTR-NTE JS");
        NOTO_SANS_CJK_LOCATION = new ResourceLocation("mtr", "font/noto-sans-cjk-tc-medium.otf");
        NOTO_SANS_LOCATION = new ResourceLocation("mtr", "font/noto-sans-semibold.ttf");
        NOTO_SERIF_LOCATION = new ResourceLocation("mtr", "font/noto-serif-cjk-tc-semibold.ttf");
        hasNotoSansCjk = false;
        FONT_CONTEXT = new FontRenderContext(new AffineTransform(), true, false);
    }
}

