/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.scripting.train;

import forge.cn.zbx1425.mtrsteamloco.MainClient;
import forge.cn.zbx1425.mtrsteamloco.render.RenderUtil;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.ScriptHolder;
import forge.cn.zbx1425.mtrsteamloco.render.scripting.train.TrainScriptContext;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.math.PoseStackUtil;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import mtr.data.TrainClient;
import mtr.render.TrainRendererBase;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ScriptedTrainRenderer
extends TrainRendererBase {
    public final ScriptHolder typeScripting;
    public final TrainRendererBase baseRenderer;
    private final TrainClient train;
    private final TrainScriptContext trainScripting;

    public ScriptedTrainRenderer(ScriptHolder typeScripting, TrainRendererBase baseRenderer) {
        this.typeScripting = typeScripting;
        this.baseRenderer = baseRenderer;
        this.train = null;
        this.trainScripting = null;
    }

    private ScriptedTrainRenderer(ScriptedTrainRenderer base, TrainClient trainClient) {
        this.typeScripting = base.typeScripting;
        this.baseRenderer = base.baseRenderer == null ? null : base.baseRenderer.createTrainInstance(trainClient);
        this.train = trainClient;
        this.trainScripting = new TrainScriptContext(trainClient);
    }

    public TrainRendererBase createTrainInstance(TrainClient trainClient) {
        ScriptedTrainRenderer result = new ScriptedTrainRenderer(this, trainClient);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderCar(int carIndex, double x, double y, double z, float yaw, float pitch, boolean doorLeftOpen, boolean doorRightOpen) {
        boolean shouldRender;
        assert (this.train != null && this.trainScripting != null);
        boolean bl = shouldRender = !RenderUtil.shouldSkipRenderTrain(this.train);
        if (shouldRender && this.baseRenderer != null) {
            this.baseRenderer.renderCar(carIndex, x, y, z, yaw, pitch, doorLeftOpen, doorRightOpen);
        }
        if (isTranslucentBatch) {
            return;
        }
        BlockPos posAverage = ScriptedTrainRenderer.applyAverageTransform((Vec3)this.train.getViewOffset(), (double)x, (double)y, (double)z);
        Vector3f carPos = new Vector3f((float)x, (float)y, (float)z);
        Vec3 offset = this.train.vehicleRidingClient.getVehicleOffset();
        if (offset != null) {
            carPos.add((float)offset.f_82479_, (float)offset.f_82480_, (float)offset.f_82481_);
        }
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        Matrix4f worldPose = new Matrix4f();
        worldPose.translate(carPos.x(), carPos.y(), carPos.z());
        worldPose.rotateY((float)Math.PI + yaw);
        worldPose.rotateX(hasPitch ? pitch : 0.0f);
        this.trainScripting.trainExtraWriting.doorLeftOpen[carIndex] = doorLeftOpen;
        this.trainScripting.trainExtraWriting.doorRightOpen[carIndex] = doorRightOpen;
        this.trainScripting.trainExtraWriting.lastWorldPose[carIndex] = worldPose;
        this.trainScripting.trainExtraWriting.lastCarPosition[carIndex] = carPos.copy();
        this.trainScripting.trainExtraWriting.lastCarRotation[carIndex] = new Vector3f(hasPitch ? pitch : 0.0f, (float)Math.PI + yaw, 0.0f);
        this.trainScripting.trainExtraWriting.isInDetailDistance = this.trainScripting.trainExtraWriting.isInDetailDistance | (posAverage != null && posAverage.m_123331_((Vec3i)camera.m_90588_()) <= 1024.0);
        this.trainScripting.trainExtraWriting.shouldRender = shouldRender;
        if (posAverage == null) {
            if (carIndex == this.train.trainCars - 1) {
                this.trainScripting.extraFinished();
                this.typeScripting.tryCallRenderFunctionAsync(this.trainScripting);
            }
            return;
        }
        matrices.m_85837_(x, y, z);
        PoseStackUtil.rotY(matrices, (float)Math.PI + yaw);
        PoseStackUtil.rotX(matrices, hasPitch ? pitch : 0.0f);
        int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
        Matrix4f drawPose = new Matrix4f(matrices.m_85850_().m_252922_());
        if (shouldRender) {
            TrainScriptContext trainScriptContext = this.trainScripting;
            synchronized (trainScriptContext) {
                this.trainScripting.scriptResult.commitCar(carIndex, MainClient.drawScheduler, drawPose, worldPose, light);
            }
        }
        matrices.m_85849_();
        if (carIndex == this.train.trainCars - 1) {
            this.trainScripting.extraFinished();
            this.typeScripting.tryCallRenderFunctionAsync(this.trainScripting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderConnection(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
        assert (this.train != null && this.trainScripting != null);
        if (RenderUtil.shouldSkipRenderTrain(this.train)) {
            return;
        }
        if (this.baseRenderer != null) {
            this.baseRenderer.renderConnection(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
        if (isTranslucentBatch) {
            return;
        }
        BlockPos posAverage = ScriptedTrainRenderer.applyAverageTransform((Vec3)this.train.getViewOffset(), (double)x, (double)y, (double)z);
        if (posAverage == null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(x, y, z);
        PoseStackUtil.rotY(matrices, (float)Math.PI + yaw);
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        PoseStackUtil.rotX(matrices, hasPitch ? pitch : 0.0f);
        int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
        Matrix4f pose = new Matrix4f(matrices.m_85850_().m_252922_());
        TrainScriptContext trainScriptContext = this.trainScripting;
        synchronized (trainScriptContext) {
            this.trainScripting.scriptResult.commitConn(0, MainClient.drawScheduler, pose, light);
            matrices.m_85849_();
            this.trainScripting.scriptResult.commitConnImmediate(0, matrices, vertexConsumers, prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, light);
        }
        matrices.m_85849_();
    }

    public void renderBarrier(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
        assert (this.train != null && this.trainScripting != null);
        if (RenderUtil.shouldSkipRenderTrain(this.train)) {
            return;
        }
        if (this.baseRenderer != null) {
            this.baseRenderer.renderBarrier(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
    }
}

