/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.scripting.train;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcerext.model.ModelCluster;
import forge.cn.zbx1425.sowcerext.reuse.DrawScheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mtr.client.IDrawing;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class TrainDrawCalls {
    private final List<ClusterDrawCall>[] carDrawLists;
    private final List<ClusterDrawCall>[] connDrawLists;
    private final ResourceLocation[] connStretchTextures;
    private final List<PlayCarSoundCall>[] carSoundLists;

    public TrainDrawCalls(int carCount) {
        this.carDrawLists = new List[carCount];
        Arrays.setAll(this.carDrawLists, ignored -> new ArrayList());
        this.connDrawLists = new List[carCount - 1];
        Arrays.setAll(this.connDrawLists, ignored -> new ArrayList());
        this.connStretchTextures = new ResourceLocation[carCount - 1];
        this.carSoundLists = new List[carCount];
        Arrays.setAll(this.carSoundLists, ignored -> new ArrayList());
    }

    public void addCarModel(int car, ModelCluster model, Matrix4f pose) {
        this.carDrawLists[car].add(new ClusterDrawCall(model, pose));
    }

    public void addCarSound(int car, SoundEvent sound, Vector3f position, float volume, float pitch) {
        this.carSoundLists[car].add(new PlayCarSoundCall(sound, position, volume, pitch));
    }

    public void commitCar(int car, DrawScheduler drawScheduler, Matrix4f basePose, Matrix4f worldPose, int light) {
        for (ClusterDrawCall clusterDrawCall : this.carDrawLists[car]) {
            Matrix4f finalPose = basePose.copy();
            finalPose.multiply(clusterDrawCall.pose);
            drawScheduler.enqueue(clusterDrawCall.model, finalPose, light);
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (PlayCarSoundCall playCarSoundCall : this.carSoundLists[car]) {
            Vector3f worldPos = worldPose.transform(playCarSoundCall.position);
            level.m_7785_((double)worldPos.x(), (double)worldPos.y(), (double)worldPos.z(), playCarSoundCall.sound, SoundSource.BLOCKS, playCarSoundCall.volume, playCarSoundCall.pitch, false);
        }
    }

    public void addConnModel(int car, ModelCluster model, Matrix4f pose) {
        this.connDrawLists[car].add(new ClusterDrawCall(model, pose));
    }

    public void drawConnStretchTexture(int car, ResourceLocation texture) {
        this.connStretchTextures[car] = texture;
    }

    public void commitConn(int car, DrawScheduler drawScheduler, Matrix4f basePose, int light) {
        for (ClusterDrawCall clusterDrawCall : this.connDrawLists[car]) {
            Matrix4f finalPose = basePose.copy();
            finalPose.multiply(clusterDrawCall.pose);
            drawScheduler.enqueue(clusterDrawCall.model, finalPose, light);
        }
    }

    public void commitConnImmediate(int car, PoseStack matrices, MultiBufferSource vertexConsumers, Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, int light) {
        if (this.connStretchTextures[car] != null) {
            VertexConsumer vertexConsumerExterior = vertexConsumers.m_6299_(MoreRenderLayers.getExterior((ResourceLocation)this.connStretchTextures[car]));
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, 0.0f, 0.0f, 0.5f, 0.5f, light);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, 0.0f, 0.0f, 0.5f, 0.5f, light);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos3, prevPos2, 0.0f, 0.0f, 0.5f, 0.5f, light);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, prevPos1, thisPos4, thisPos1, prevPos4, 0.0f, 0.0f, 0.5f, 0.5f, light);
            int lightOnLevel = 0xF000F0;
            VertexConsumer vertexConsumerSide = vertexConsumers.m_6299_(MoreRenderLayers.getInterior((ResourceLocation)this.connStretchTextures[car]));
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, thisPos3, prevPos2, prevPos1, thisPos4, 0.5f, 0.0f, 1.0f, 0.5f, lightOnLevel);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, prevPos3, thisPos2, thisPos1, prevPos4, 0.5f, 0.0f, 1.0f, 0.5f, lightOnLevel);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, prevPos2, thisPos3, thisPos2, prevPos3, 0.0f, 0.5f, 0.5f, 1.0f, lightOnLevel);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, prevPos4, thisPos1, thisPos4, prevPos1, 0.5f, 0.5f, 1.0f, 1.0f, lightOnLevel);
        }
    }

    private static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, Vec3 pos1, Vec3 pos2, Vec3 pos3, Vec3 pos4, float u1, float v1, float u2, float v2, int light) {
        IDrawing.drawTexture((PoseStack)matrices, (VertexConsumer)vertexConsumer, (float)((float)pos1.f_82479_), (float)((float)pos1.f_82480_), (float)((float)pos1.f_82481_), (float)((float)pos2.f_82479_), (float)((float)pos2.f_82480_), (float)((float)pos2.f_82481_), (float)((float)pos3.f_82479_), (float)((float)pos3.f_82480_), (float)((float)pos3.f_82481_), (float)((float)pos4.f_82479_), (float)((float)pos4.f_82480_), (float)((float)pos4.f_82481_), (float)u1, (float)v1, (float)u2, (float)v2, (Direction)Direction.UP, (int)-1, (int)light);
    }

    public void reset() {
        for (List<ClusterDrawCall> list : this.carDrawLists) {
            list.clear();
        }
        for (List<ClusterDrawCall> list : this.connDrawLists) {
            list.clear();
        }
        for (List<Object> list : this.carSoundLists) {
            list.clear();
        }
        Arrays.fill(this.connStretchTextures, null);
    }

    private static class ClusterDrawCall {
        public ModelCluster model;
        public Matrix4f pose;

        public ClusterDrawCall(ModelCluster model, Matrix4f pose) {
            this.model = model;
            this.pose = pose;
        }
    }

    private static class PlayCarSoundCall {
        public SoundEvent sound;
        public Vector3f position;
        public float volume;
        public float pitch;

        public PlayCarSoundCall(SoundEvent sound, Vector3f position, float volume, float pitch) {
            this.sound = sound;
            this.position = position;
            this.volume = volume;
            this.pitch = pitch;
        }
    }
}

