/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.scripting.train;

import forge.cn.zbx1425.mtrsteamloco.mixin.TrainAccessor;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import mtr.MTRClient;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.data.Platform;
import mtr.data.RailType;
import mtr.data.Route;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.data.Train;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.path.PathData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;

public class TrainWrapper {
    public boolean[] doorLeftOpen;
    public boolean[] doorRightOpen;
    public Matrix4f[] lastWorldPose;
    public Vector3f[] lastCarPosition;
    public Vector3f[] lastCarRotation;
    public boolean shouldRender;
    public boolean isInDetailDistance;
    private final TrainClient train;
    private PlatformLookupMap trainPlatforms;
    private List<PathData> trainPlatformsValidPath;

    public TrainWrapper(TrainClient train) {
        this.doorLeftOpen = new boolean[train.trainCars];
        this.doorRightOpen = new boolean[train.trainCars];
        this.lastWorldPose = new Matrix4f[train.trainCars];
        this.lastCarPosition = new Vector3f[train.trainCars];
        this.lastCarRotation = new Vector3f[train.trainCars];
        Arrays.setAll(this.lastWorldPose, ignored -> Matrix4f.translation(0.0f, -10000.0f, 0.0f));
        Arrays.setAll(this.lastCarPosition, ignored -> new Vector3f(0.0f, -10000.0f, 0.0f));
        Arrays.setAll(this.lastCarRotation, ignored -> new Vector3f(0.0f, 0.0f, 0.0f));
        this.train = train;
        this.reset();
    }

    public void reset() {
        if (this.trainPlatformsValidPath == null || !this.trainPlatformsValidPath.equals(this.train.path)) {
            if (!this.train.getRouteIds().isEmpty()) {
                this.trainPlatforms = this.getTrainPlatforms();
                this.trainPlatformsValidPath = this.train.path;
            } else {
                this.trainPlatforms = new PlatformLookupMap();
            }
        }
        this.isInDetailDistance = false;
    }

    private PlatformLookupMap getTrainPlatforms() {
        List routeIds = this.train.getRouteIds();
        ClientCache dataCache = ClientData.DATA_CACHE;
        PlatformLookupMap result = new PlatformLookupMap();
        result.siding = (Siding)dataCache.sidingIdMap.get(this.train.sidingId);
        if (routeIds.isEmpty()) {
            return result;
        }
        int routeIndex = 0;
        ArrayList<PlatformInfo> currentRoutePlatforms = new ArrayList<PlatformInfo>();
        for (int pathIndex = 0; pathIndex < this.train.path.size(); ++pathIndex) {
            if (((PathData)this.train.path.get((int)pathIndex)).dwellTime <= 0 || ((PathData)this.train.path.get((int)pathIndex)).rail.railType != RailType.PLATFORM) continue;
            if (routeIndex >= routeIds.size()) break;
            Route thisRoute = (Route)dataCache.routeIdMap.get(routeIds.get(routeIndex));
            Route nextRoute = routeIndex < routeIds.size() - 1 ? (Route)dataCache.routeIdMap.get(routeIds.get(routeIndex + 1)) : null;
            boolean reverseAtPlatform = !thisRoute.platformIds.isEmpty() && nextRoute != null && !nextRoute.platformIds.isEmpty() && thisRoute.getLastPlatformId() == nextRoute.getFirstPlatformId();
            int routeStationIndex = currentRoutePlatforms.size();
            Station thisStation = (Station)dataCache.platformIdToStation.get(((Route.RoutePlatform)thisRoute.platformIds.get((int)routeStationIndex)).platformId);
            Platform thisPlatform = (Platform)dataCache.platformIdMap.get(((Route.RoutePlatform)thisRoute.platformIds.get((int)routeStationIndex)).platformId);
            String customDestination = thisRoute.getDestination(routeStationIndex);
            double distance = ((TrainAccessor)this.train).getDistances().get(pathIndex);
            boolean reverseAtThisPlatform = currentRoutePlatforms.size() + 1 >= thisRoute.platformIds.size() && reverseAtPlatform;
            Station lastStation = (Station)ClientData.DATA_CACHE.platformIdToStation.get(thisRoute.getLastPlatformId());
            PlatformInfo platformInfo = new PlatformInfo(thisRoute, thisStation, thisPlatform, lastStation, customDestination != null ? customDestination : (lastStation != null ? lastStation.name : ""), distance, reverseAtThisPlatform);
            result.pathToPlatformIndex.put(pathIndex, result.platforms.size());
            result.platforms.add(platformInfo);
            result.pathToRoutePlatformIndex.put(pathIndex, currentRoutePlatforms.size());
            currentRoutePlatforms.add(platformInfo);
            if (currentRoutePlatforms.size() < thisRoute.platformIds.size()) continue;
            result.pathToRoutePlatforms.put(pathIndex, currentRoutePlatforms);
            currentRoutePlatforms = new ArrayList();
            ++routeIndex;
            if (!reverseAtPlatform) continue;
            currentRoutePlatforms.add(platformInfo);
        }
        return result;
    }

    public List<PlatformInfo> getAllPlatforms() {
        return this.trainPlatforms.platforms;
    }

    public int getAllPlatformsNextIndex() {
        int headIndex = this.train.getIndex(0, this.train.spacing, true);
        Map.Entry<Integer, Integer> ceilEntry = this.trainPlatforms.pathToPlatformIndex.ceilingEntry(headIndex);
        if (ceilEntry == null) {
            return this.trainPlatforms.platforms.size();
        }
        return ceilEntry.getValue();
    }

    @Deprecated
    public PlatformInfo getPlatformRelative(int offset, boolean allowDifferentRoute) {
        int ceilEntry = this.getAllPlatformsNextIndex();
        int queryIndex = ceilEntry + offset;
        if (queryIndex < 0 || queryIndex > this.trainPlatforms.platforms.size() - 1 || !allowDifferentRoute && !Objects.equals(this.trainPlatforms.platforms.get((int)queryIndex).route.id, this.trainPlatforms.platforms.get((int)Math.min((int)ceilEntry, (int)(this.trainPlatforms.platforms.size() - 1))).route.id)) {
            return null;
        }
        return this.trainPlatforms.platforms.get(queryIndex);
    }

    public List<PlatformInfo> getThisRoutePlatforms() {
        int headIndex = this.train.getIndex(0, this.train.spacing, true);
        Map.Entry<Integer, List<PlatformInfo>> ceilEntry = this.trainPlatforms.pathToRoutePlatforms.ceilingEntry(headIndex);
        if (ceilEntry == null) {
            return List.of();
        }
        return ceilEntry.getValue();
    }

    public List<PlatformInfo> getNextRoutePlatforms() {
        int headIndex = this.train.getIndex(0, this.train.spacing, true);
        Map.Entry<Integer, List<PlatformInfo>> ceilEntry = this.trainPlatforms.pathToRoutePlatforms.higherEntry(headIndex);
        if (ceilEntry == null) {
            return List.of();
        }
        return ceilEntry.getValue();
    }

    public int getThisRoutePlatformsNextIndex() {
        int headIndex = this.train.getIndex(0, this.train.spacing, true);
        Map.Entry<Integer, Integer> ceilEntry = this.trainPlatforms.pathToRoutePlatformIndex.ceilingEntry(headIndex);
        if (ceilEntry == null) {
            return this.getThisRoutePlatforms().size();
        }
        return ceilEntry.getValue();
    }

    public List<PlatformInfo> getDebugThisRoutePlatforms(int count) {
        ArrayList<PlatformInfo> result = new ArrayList<PlatformInfo>();
        Route debugRoute = new Route(TransportMode.TRAIN);
        debugRoute.name = "\u8c03\u8bd5\u7ebf\u8def|Debug Route";
        Station destinationStation = new Station();
        destinationStation.name = String.format("\u8f66\u7ad9 %d|Station %d", count, count);
        for (int i = 0; i < count; ++i) {
            Station currentStation = new Station();
            currentStation.name = String.format("\u8f66\u7ad9 %d|Station %d", i + 1, i + 1);
            Platform currentPlatform = new Platform(TransportMode.TRAIN, BlockPos.f_121853_, BlockPos.f_121853_);
            currentPlatform.name = "1";
            result.add(new PlatformInfo(debugRoute, currentStation, currentPlatform, destinationStation, destinationStation.name, i * 1000, false));
        }
        return result;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    public boolean shouldRenderDetail() {
        return this.shouldRender && (MTRClient.isReplayMod() || this.isInDetailDistance);
    }

    public boolean isClientPlayerRiding() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && this.train.isPlayerRiding((Player)player);
    }

    public Train mtrTrain() {
        return this.train;
    }

    public long id() {
        return this.train.id;
    }

    public Siding siding() {
        return this.trainPlatforms.siding;
    }

    public String trainTypeId() {
        return this.train.trainId;
    }

    public String baseTrainType() {
        return this.train.baseTrainType;
    }

    public TransportMode transportMode() {
        return this.train.transportMode;
    }

    public int spacing() {
        return this.train.spacing;
    }

    public int width() {
        return this.train.width;
    }

    public int trainCars() {
        return this.train.trainCars;
    }

    public float accelerationConstant() {
        return this.train.accelerationConstant;
    }

    public boolean manualAllowed() {
        return this.train.isManualAllowed;
    }

    public int maxManualSpeed() {
        return this.train.maxManualSpeed;
    }

    public int manualToAutomaticTime() {
        return this.train.manualToAutomaticTime;
    }

    public List<PathData> path() {
        return this.train.path;
    }

    public double railProgress() {
        return this.train.getRailProgress();
    }

    public double getRailProgress(int car) {
        return this.train.getRailProgress() - (double)(car * this.train.spacing);
    }

    public int getRailIndex(double railProgress, boolean roundDown) {
        return this.train.getIndex(railProgress, roundDown);
    }

    public float getRailSpeed(int railIndex) {
        return this.train.getRailSpeed(railIndex);
    }

    public float speed() {
        return this.train.getSpeed();
    }

    public float doorValue() {
        return this.train.getDoorValue();
    }

    public boolean isCurrentlyManual() {
        return this.train.isCurrentlyManual();
    }

    public boolean isReversed() {
        return this.train.isReversed();
    }

    public boolean isOnRoute() {
        return this.train.isOnRoute();
    }

    public boolean justOpening() {
        return this.train.justOpening();
    }

    public boolean justClosing(float doorCloseTime) {
        return this.train.justClosing(doorCloseTime);
    }

    public final boolean isDoorOpening() {
        return this.train.isDoorOpening();
    }

    private static class PlatformLookupMap {
        public Siding siding;
        public final List<PlatformInfo> platforms = new ArrayList<PlatformInfo>();
        public final TreeMap<Integer, Integer> pathToPlatformIndex = new TreeMap();
        public final TreeMap<Integer, List<PlatformInfo>> pathToRoutePlatforms = new TreeMap();
        public final TreeMap<Integer, Integer> pathToRoutePlatformIndex = new TreeMap();

        private PlatformLookupMap() {
        }
    }

    public static class PlatformInfo {
        public Route route;
        public Station station;
        public Platform platform;
        public Station destinationStation;
        public String destinationName;
        public double distance;
        public boolean reverseAtPlatform;

        public PlatformInfo(Route route, Station station, Platform platform, Station destinationStation, String destinationName, double distance, boolean reverseAtPlatform) {
            this.route = route;
            this.station = station;
            this.platform = platform;
            this.destinationStation = destinationStation;
            this.destinationName = destinationName;
            this.distance = distance;
            this.reverseAtPlatform = reverseAtPlatform;
        }
    }
}

