/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.scripting.util;

import forge.cn.zbx1425.mtrsteamloco.render.scripting.util.TimingUtil;

public class CycleTracker {
    private final String[] states;
    private final float[] offsets;
    private final float cycleDuration;
    private String lastState;
    private String currentState;
    private double currentStateTime;
    private int lastStateNum;
    private boolean firstTimeCurrentState;

    public CycleTracker(Object[] params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        float offset = 0.0f;
        this.states = new String[params.length / 2];
        this.offsets = new float[params.length / 2];
        for (int i = 0; i < params.length; i += 2) {
            this.states[i / 2] = params[i].toString();
            float elemDuration = Float.parseFloat(params[i + 1].toString());
            this.offsets[i / 2] = offset;
            offset += elemDuration;
        }
        this.cycleDuration = offset;
    }

    public void tick() {
        double time = TimingUtil.elapsed() % (double)this.cycleDuration;
        int cycleNum = (int)(TimingUtil.elapsed() / (double)this.cycleDuration);
        for (int i = this.offsets.length - 1; i >= 0; --i) {
            if (!(time >= (double)this.offsets[i])) continue;
            int stateNum = cycleNum * this.offsets.length + i;
            this.currentState = this.states[i];
            this.currentStateTime = this.offsets[i];
            this.lastState = this.states[i == 0 ? this.offsets.length - 1 : i - 1];
            if (this.lastStateNum != stateNum) {
                this.firstTimeCurrentState = true;
                this.lastStateNum = stateNum;
                break;
            }
            this.firstTimeCurrentState = false;
            break;
        }
    }

    public String stateNow() {
        return this.currentState;
    }

    public String stateLast() {
        return this.lastState;
    }

    public double stateNowDuration() {
        return TimingUtil.elapsed() - this.currentStateTime;
    }

    public boolean stateNowFirst() {
        return this.firstTimeCurrentState;
    }
}

