/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.render.train;

import forge.cn.zbx1425.mtrsteamloco.ClientConfig;
import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.mtrsteamloco.MainClient;
import forge.cn.zbx1425.mtrsteamloco.render.RenderUtil;
import forge.cn.zbx1425.mtrsteamloco.render.train.RenderTrainDK3;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.math.PoseStackUtil;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcerext.multipart.MultipartContainer;
import forge.cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import forge.cn.zbx1425.sowcerext.multipart.animated.AnimatedLoader;
import java.io.IOException;
import mtr.MTRClient;
import mtr.data.TrainClient;
import mtr.render.TrainRendererBase;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class RenderTrainD51
extends TrainRendererBase {
    protected static MultipartContainer modelD51;
    private final TrainClient train;
    private final MultipartUpdateProp updateProp = new MultipartUpdateProp();
    private final TrainRendererBase trailingCarRenderer;
    private static int renderingCarNum;

    public static void initGLModel(ResourceManager resourceManager) {
        try {
            MainClient.atlasManager.load(resourceManager, new ResourceLocation("mtrsteamloco:models/atlas/d51.json"));
            modelD51 = AnimatedLoader.loadModel(resourceManager, MainClient.modelManager, MainClient.atlasManager, new ResourceLocation("mtrsteamloco:models/d51/d51.animated"));
        }
        catch (IOException e) {
            modelD51 = null;
            Main.LOGGER.error("Failed loading model for D51:", (Throwable)e);
        }
    }

    public RenderTrainD51(TrainRendererBase trailingCarRenderer) {
        this.train = null;
        this.trailingCarRenderer = trailingCarRenderer;
    }

    private RenderTrainD51(TrainClient trainClient, TrainRendererBase trailingCarRenderer) {
        this.train = trainClient;
        this.trailingCarRenderer = trailingCarRenderer == null ? null : trailingCarRenderer.createTrainInstance(this.train);
    }

    public TrainRendererBase createTrainInstance(TrainClient trainClient) {
        return new RenderTrainD51(trainClient, this.trailingCarRenderer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void renderCar(int carIndex, double x, double y, double z, float yaw, float pitch, boolean doorLeftOpen, boolean doorRightOpen) {
        int carNum;
        if (RenderUtil.shouldSkipRenderTrain(this.train)) {
            return;
        }
        renderingCarNum = carNum = !this.train.isReversed() ? carIndex : this.train.trainCars - carIndex - 1;
        if (this.trailingCarRenderer != null && carNum != 0) {
            int carNumToRender;
            matrices.m_85836_();
            if (this.trailingCarRenderer instanceof RenderTrainDK3) {
                if (carNum == 1) {
                    carNumToRender = this.train.trainCars < 3 ? 1 : 0;
                } else {
                    if (carNum != 2) {
                        matrices.m_85849_();
                        return;
                    }
                    carNumToRender = this.train.trainCars - 1;
                }
            } else {
                carNumToRender = carNum == this.train.trainCars - 1 ? carNum : carNum - 1;
            }
            int carIndexToRender = !this.train.isReversed() ? carNumToRender : this.train.trainCars - carNumToRender - 1;
            this.trailingCarRenderer.renderCar(carIndexToRender, x, y, z, yaw, pitch, doorLeftOpen, doorRightOpen);
            matrices.m_85849_();
            return;
        }
        if (isTranslucentBatch) {
            return;
        }
        BlockPos posAverage = RenderTrainD51.applyAverageTransform((Vec3)this.train.getViewOffset(), (double)x, (double)y, (double)z);
        if (posAverage == null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(x, y - 1.0, z);
        PoseStackUtil.rotY(matrices, (float)Math.PI + yaw);
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        PoseStackUtil.rotX(matrices, hasPitch ? pitch : 0.0f);
        if (this.train.isReversed()) {
            PoseStackUtil.rotY(matrices, (float)Math.PI);
        }
        int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
        this.updateProp.update(this.train, carIndex, !this.train.isReversed());
        Matrix4f pose = new Matrix4f(matrices.m_85850_().m_252922_());
        modelD51.updateAndEnqueueAll(MainClient.drawScheduler, this.updateProp, pose, light);
        if (ClientConfig.enableSmoke && this.train.getIsOnRoute() && (int)MTRClient.getGameTick() % 4 == 0) {
            Vector3f smokeOrigin = new Vector3f(0.0f, 2.7f, 8.4f);
            Vector3f carPos = new Vector3f((float)x, (float)y, (float)z);
            Vec3 offset = this.train.vehicleRidingClient.getVehicleOffset();
            if (offset != null) {
                carPos.add((float)offset.f_82479_, (float)offset.f_82480_, (float)offset.f_82481_);
            }
            smokeOrigin.rotX(pitch);
            smokeOrigin.rotY((!this.train.isReversed() ? (float)Math.PI : 0.0f) + yaw);
            smokeOrigin.add(carPos);
            world.m_7106_((ParticleOptions)Main.PARTICLE_STEAM_SMOKE, (double)smokeOrigin.x(), (double)smokeOrigin.y(), (double)smokeOrigin.z(), 0.0, (double)0.7f, 0.0);
        }
        matrices.m_85849_();
        matrices.m_85849_();
    }

    public void renderConnection(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
        if (this.trailingCarRenderer != null && renderingCarNum > 1) {
            this.trailingCarRenderer.renderConnection(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
    }

    public void renderBarrier(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
        if (this.trailingCarRenderer != null && renderingCarNum > 1) {
            this.trailingCarRenderer.renderBarrier(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
    }

    static {
        renderingCarNum = 0;
    }
}

