/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.sound;

import mtr.MTRClient;
import mtr.data.TrainClient;
import mtr.sound.TrainSoundBase;
import mtr.sound.bve.BveTrainSound;
import mtr.sound.bve.BveTrainSoundConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class DwellTimeBveTrainSound
extends TrainSoundBase {
    private BveTrainSound bveTrainSound;
    private TrainClient train;
    public float oldStopTicks = 0.0f;
    private float elapsedDwellTicks = 0.0f;
    private float totalDwellTicks = 0.0f;
    private float lastRenderedTick = 0.0f;

    public DwellTimeBveTrainSound(BveTrainSoundConfig config) {
        this.bveTrainSound = new BveTrainSound(config);
    }

    private DwellTimeBveTrainSound() {
    }

    public TrainSoundBase createTrainInstance(TrainClient train) {
        DwellTimeBveTrainSound result = new DwellTimeBveTrainSound();
        result.bveTrainSound = (BveTrainSound)this.bveTrainSound.createTrainInstance(train);
        result.train = train;
        return result;
    }

    public void playNearestCar(Level level, BlockPos blockPos, int i) {
        this.bveTrainSound.playNearestCar(level, blockPos, i);
    }

    public void playAllCars(Level level, BlockPos blockPos, int i) {
        this.bveTrainSound.playAllCars(level, blockPos, i);
    }

    public void playAllCarsDoorOpening(Level world, BlockPos pos, int carIndex) {
        if (!(world instanceof ClientLevel) || this.train == null) {
            return;
        }
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        float ticksElapsed = Minecraft.m_91087_().m_91104_() || this.lastRenderedTick == MTRClient.getGameTick() ? 0.0f : lastFrameDuration;
        this.lastRenderedTick = MTRClient.getGameTick();
        this.elapsedDwellTicks += ticksElapsed;
        if (this.train.justOpening()) {
            this.elapsedDwellTicks = 0.0f;
            this.totalDwellTicks = this.train.getTotalDwellTicks();
        }
        int dwellTicks = (int)(this.totalDwellTicks - 20.0f);
        float stopTicks = this.elapsedDwellTicks;
        SoundEvent soundEvent = this.train.justOpening() && this.bveTrainSound.config.soundCfg.doorOpen != null ? this.bveTrainSound.config.soundCfg.doorOpen : (this.bveTrainSound.config.soundCfg.doorClose != null && this.oldStopTicks <= (float)dwellTicks - this.bveTrainSound.config.soundCfg.doorCloseSoundLength * 20.0f && stopTicks > (float)dwellTicks - this.bveTrainSound.config.soundCfg.doorCloseSoundLength * 20.0f ? this.bveTrainSound.config.soundCfg.doorClose : null);
        this.oldStopTicks = stopTicks;
        DwellTimeBveTrainSound.playLocalSound(world, soundEvent, pos);
    }

    private static void playLocalSound(Level world, SoundEvent event, BlockPos pos) {
        if (event == null) {
            return;
        }
        ((ClientLevel)world).m_245747_(pos, event, SoundSource.BLOCKS, 1.0f, 1.0f, false);
    }
}

