/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api;

import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.ValueHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
@ApiStatus.Experimental
public interface Requirement {
    public boolean check();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SafeVarargs
    public static <T> Requirement isValue(ValueHolder<T> dependency, @Nullable T firstValue, T ... otherValues) {
        @Nullable Set values = Stream.concat(Stream.of(firstValue), Arrays.stream(otherValues)).collect(Collectors.toCollection(HashSet::new));
        return () -> values.contains(dependency.getValue());
    }

    public static <T> Requirement matches(ValueHolder<T> firstDependency, ValueHolder<T> secondDependency) {
        return () -> Objects.equals(firstDependency.getValue(), secondDependency.getValue());
    }

    public static Requirement isTrue(ValueHolder<Boolean> dependency) {
        return () -> Boolean.TRUE.equals(dependency.getValue());
    }

    public static Requirement isFalse(ValueHolder<Boolean> dependency) {
        return () -> Boolean.FALSE.equals(dependency.getValue());
    }

    public static Requirement not(Requirement requirement) {
        return () -> !requirement.check();
    }

    public static Requirement all(Requirement ... requirements) {
        return () -> Arrays.stream(requirements).allMatch(Requirement::check);
    }

    public static Requirement any(Requirement ... requirements) {
        return () -> Arrays.stream(requirements).anyMatch(Requirement::check);
    }

    public static Requirement none(Requirement ... requirements) {
        return () -> Arrays.stream(requirements).noneMatch(Requirement::check);
    }

    public static Requirement one(Requirement ... requirements) {
        return () -> {
            boolean oneFound = false;
            for (Requirement requirement : requirements) {
                if (!requirement.check()) continue;
                if (oneFound) {
                    return false;
                }
                oneFound = true;
            }
            return oneFound;
        };
    }
}

