/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator;

import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator.ConventionValueAnimator;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator.DoubleValueAnimatorImpl;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator.MappingValueAnimator;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator.ProgressValueAnimator;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator.RecordValueAnimator;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.api.animator.ValueProvider;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.math.Color;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.math.Dimension;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.math.FloatingDimension;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.math.FloatingPoint;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.math.FloatingRectangle;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.math.Point;
import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.math.Rectangle;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public interface ValueAnimator<T>
extends ValueProvider<T> {
    public static long typicalTransitionTime() {
        return 700L;
    }

    public static NumberAnimator<Double> ofDouble() {
        return new DoubleValueAnimatorImpl(0.0);
    }

    public static NumberAnimator<Float> ofFloat() {
        return ValueAnimator.ofDouble().asFloat();
    }

    public static NumberAnimator<Integer> ofInt() {
        return ValueAnimator.ofDouble().asInt();
    }

    public static NumberAnimator<Long> ofLong() {
        return ValueAnimator.ofDouble().asLong();
    }

    public static ProgressValueAnimator<Boolean> ofBoolean() {
        return ValueAnimator.ofBoolean(50.0);
    }

    public static ProgressValueAnimator<Boolean> ofBoolean(double switchPoint) {
        return ProgressValueAnimator.mapProgress(ValueAnimator.ofDouble(), d -> d > switchPoint / 100.0, b -> b != false ? 100.0 : 0.0);
    }

    public static ValueAnimator<Color> ofColor() {
        return RecordValueAnimator.of(ValueAnimator.ofInt(), ValueAnimator.ofInt(), ValueAnimator.ofInt(), ValueAnimator.ofInt(), Color::ofRGBA, (color, r, g, b, a) -> {
            r.set(color.getRed());
            g.set(color.getGreen());
            b.set(color.getBlue());
            a.set(color.getAlpha());
        });
    }

    public static ValueAnimator<Rectangle> ofRectangle() {
        return RecordValueAnimator.of(ValueAnimator.ofInt(), ValueAnimator.ofInt(), ValueAnimator.ofInt(), ValueAnimator.ofInt(), Rectangle::new, (rectangle, x, y, width, height) -> {
            x.set(rectangle.x);
            y.set(rectangle.y);
            width.set(rectangle.width);
            height.set(rectangle.height);
        });
    }

    public static ValueAnimator<Dimension> ofDimension() {
        return RecordValueAnimator.of(ValueAnimator.ofInt(), ValueAnimator.ofInt(), Dimension::new, (dimension, width, height) -> {
            width.set(dimension.width);
            height.set(dimension.height);
        });
    }

    public static ValueAnimator<Point> ofPoint() {
        return RecordValueAnimator.of(ValueAnimator.ofInt(), ValueAnimator.ofInt(), Point::new, (dimension, width, height) -> {
            width.set(dimension.x);
            height.set(dimension.y);
        });
    }

    public static ValueAnimator<FloatingRectangle> ofFloatingRectangle() {
        return RecordValueAnimator.of(ValueAnimator.ofDouble(), ValueAnimator.ofDouble(), ValueAnimator.ofDouble(), ValueAnimator.ofDouble(), FloatingRectangle::new, (rectangle, x, y, width, height) -> {
            x.set(rectangle.x);
            y.set(rectangle.y);
            width.set(rectangle.width);
            height.set(rectangle.height);
        });
    }

    public static ValueAnimator<FloatingDimension> ofFloatingDimension() {
        return RecordValueAnimator.of(ValueAnimator.ofDouble(), ValueAnimator.ofDouble(), FloatingDimension::new, (dimension, width, height) -> {
            width.set(dimension.width);
            height.set(dimension.height);
        });
    }

    public static ValueAnimator<FloatingPoint> ofFloatingPoint() {
        return RecordValueAnimator.of(ValueAnimator.ofDouble(), ValueAnimator.ofDouble(), FloatingPoint::new, (dimension, width, height) -> {
            width.set(dimension.x);
            height.set(dimension.y);
        });
    }

    public static NumberAnimator<Double> ofDouble(double initialValue) {
        return new DoubleValueAnimatorImpl(initialValue);
    }

    public static NumberAnimator<Float> ofFloat(float initialValue) {
        return ValueAnimator.ofFloat().setAs(initialValue);
    }

    public static NumberAnimator<Integer> ofInt(int initialValue) {
        return ValueAnimator.ofInt().setAs(initialValue);
    }

    public static NumberAnimator<Long> ofLong(long initialValue) {
        return ValueAnimator.ofLong().setAs(initialValue);
    }

    public static ProgressValueAnimator<Boolean> ofBoolean(boolean initialValue) {
        return ValueAnimator.ofBoolean().setAs((Object)initialValue);
    }

    public static ProgressValueAnimator<Boolean> ofBoolean(double switchPoint, boolean initialValue) {
        return ValueAnimator.ofBoolean(switchPoint).setAs((Object)initialValue);
    }

    public static ValueAnimator<Color> ofColor(Color initialValue) {
        return ValueAnimator.ofColor().setAs(initialValue);
    }

    public static ValueAnimator<Rectangle> ofRectangle(Rectangle initialValue) {
        return ValueAnimator.ofRectangle().setAs(initialValue);
    }

    public static ValueAnimator<Dimension> ofDimension(Dimension initialValue) {
        return ValueAnimator.ofDimension().setAs(initialValue);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static ValueAnimator<Point> ofDimension(Point initialValue) {
        return ValueAnimator.ofPoint().setAs(initialValue);
    }

    public static ValueAnimator<Point> ofPoint(Point initialValue) {
        return ValueAnimator.ofPoint().setAs(initialValue);
    }

    public static ValueAnimator<FloatingRectangle> ofFloatingRectangle(FloatingRectangle initialValue) {
        return ValueAnimator.ofFloatingRectangle().setAs(initialValue);
    }

    public static ValueAnimator<FloatingDimension> ofFloatingDimension(FloatingDimension initialValue) {
        return ValueAnimator.ofFloatingDimension().setAs(initialValue);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static ValueAnimator<FloatingPoint> ofFloatingDimension(FloatingPoint initialValue) {
        return ValueAnimator.ofFloatingPoint().setAs(initialValue);
    }

    public static ValueAnimator<FloatingPoint> ofFloatingPoint(FloatingPoint initialValue) {
        return ValueAnimator.ofFloatingPoint().setAs(initialValue);
    }

    default public <R> ValueAnimator<R> map(Function<T, R> converter, Function<R, T> backwardsConverter) {
        return new MappingValueAnimator<T, R>(this, converter, backwardsConverter);
    }

    default public ValueAnimator<T> setAs(T value) {
        return this.setTo(value, -1L);
    }

    public ValueAnimator<T> setTo(T var1, long var2);

    public ValueAnimator<T> setTarget(T var1);

    default public ValueAnimator<T> withConvention(Supplier<T> convention, long duration) {
        return new ConventionValueAnimator<T>(this, convention, duration);
    }

    @Override
    default public void completeImmediately() {
        this.setAs(this.target());
    }
}

