/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.gui.entries;

import forge.cn.zbx1425.mtrsteamloco.vendor.me.shedaniel.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class LongListListEntry
extends AbstractTextFieldListListEntry<Long, LongListCell, LongListListEntry> {
    private long minimum = Long.MIN_VALUE;
    private long maximum = Long.MAX_VALUE;

    @Deprecated
    @ApiStatus.Internal
    public LongListListEntry(Component fieldName, List<Long> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<Long>> saveConsumer, Supplier<List<Long>> defaultValue, Component resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListListEntry(Component fieldName, List<Long> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<Long>> saveConsumer, Supplier<List<Long>> defaultValue, Component resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListListEntry(Component fieldName, List<Long> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<Long>> saveConsumer, Supplier<List<Long>> defaultValue, Component resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, LongListCell::new);
    }

    public LongListListEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    public LongListListEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public LongListListEntry self() {
        return this;
    }

    public static class LongListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Long, LongListCell, LongListListEntry> {
        public LongListCell(Long value, LongListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Long substituteDefault(@Nullable Long value) {
            if (value == null) {
                return 0L;
            }
            return value;
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45);
        }

        @Override
        public Long getValue() {
            try {
                return Long.valueOf(this.widget.m_94155_());
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }

        @Override
        public Optional<Component> getError() {
            try {
                long l = Long.parseLong(this.widget.m_94155_());
                if (l > ((LongListListEntry)this.listListEntry).maximum) {
                    return Optional.of(Component.m_237110_((String)"text.cloth-config.error.too_large", (Object[])new Object[]{((LongListListEntry)this.listListEntry).maximum}));
                }
                if (l < ((LongListListEntry)this.listListEntry).minimum) {
                    return Optional.of(Component.m_237110_((String)"text.cloth-config.error.too_small", (Object[])new Object[]{((LongListListEntry)this.listListEntry).minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(Component.m_237115_((String)"text.cloth-config.error.not_valid_number_long"));
            }
            return Optional.empty();
        }
    }
}

