/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcer.batch;

import forge.cn.zbx1425.sowcer.batch.EnqueueProp;
import forge.cn.zbx1425.sowcer.batch.MaterialProp;
import forge.cn.zbx1425.sowcer.batch.ShaderProp;
import forge.cn.zbx1425.sowcer.model.VertArrays;
import forge.cn.zbx1425.sowcer.object.VertArray;
import forge.cn.zbx1425.sowcer.shader.ShaderManager;
import forge.cn.zbx1425.sowcer.util.DrawContext;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;

public class BatchManager {
    public HashMap<BatchTuple, Queue<RenderCall>> batches = new HashMap();

    public void enqueue(VertArrays model, EnqueueProp enqueueProp, ShaderProp shaderProp) {
        for (VertArray vertArray : model.meshList) {
            this.enqueue(vertArray, enqueueProp, shaderProp);
        }
    }

    public void enqueue(VertArray vertArray, EnqueueProp enqueueProp, ShaderProp shaderProp) {
        Queue queue = this.batches.computeIfAbsent(new BatchTuple(vertArray.materialProp, shaderProp), key -> new LinkedList());
        queue.add(new RenderCall(vertArray, enqueueProp));
    }

    public void drawAll(ShaderManager shaderManager, DrawContext drawContext) {
        drawContext.recordBatches(this.batches.size());
        this.pushDebugGroup("SOWCER");
        for (Map.Entry<BatchTuple, Queue<RenderCall>> entry : this.batches.entrySet()) {
            if (entry.getKey().materialProp.translucent || entry.getKey().materialProp.cutoutHack) continue;
            this.drawBatch(shaderManager, entry, drawContext);
        }
        for (Map.Entry<BatchTuple, Queue<RenderCall>> entry : this.batches.entrySet()) {
            if (!entry.getKey().materialProp.cutoutHack) continue;
            this.drawBatch(shaderManager, entry, drawContext);
        }
        for (Map.Entry<BatchTuple, Queue<RenderCall>> entry : this.batches.entrySet()) {
            if (!entry.getKey().materialProp.translucent) continue;
            this.drawBatch(shaderManager, entry, drawContext);
        }
        this.popDebugGroup();
        this.batches.clear();
    }

    private void drawBatch(ShaderManager shaderManager, Map.Entry<BatchTuple, Queue<RenderCall>> entry, DrawContext drawContext) {
        this.pushDebugGroup(entry.getKey().materialProp.toString());
        shaderManager.setupShaderBatchState(entry.getKey().materialProp, entry.getKey().shaderProp);
        Queue<RenderCall> queue = entry.getValue();
        while (!queue.isEmpty()) {
            RenderCall renderCall = queue.poll();
            renderCall.draw();
            drawContext.recordDrawCall(renderCall);
        }
        shaderManager.cleanupShaderBatchState(entry.getKey().materialProp, entry.getKey().shaderProp);
        this.popDebugGroup();
    }

    private void pushDebugGroup(String name) {
    }

    private void popDebugGroup() {
    }

    private static class BatchTuple {
        public MaterialProp materialProp;
        public ShaderProp shaderProp;

        public BatchTuple(MaterialProp materialProp, ShaderProp shaderProp) {
            this.materialProp = materialProp;
            this.shaderProp = shaderProp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BatchTuple that = (BatchTuple)o;
            return this.materialProp.equals(that.materialProp) && this.shaderProp.equals(that.shaderProp);
        }

        public int hashCode() {
            return Objects.hash(this.materialProp, this.shaderProp);
        }
    }

    public static class RenderCall {
        public VertArray vertArray;
        public EnqueueProp enqueueProp;

        public RenderCall(VertArray vertArray, EnqueueProp enqueueProp) {
            this.vertArray = vertArray;
            this.enqueueProp = enqueueProp;
        }

        public void draw() {
            this.vertArray.bind();
            if (this.enqueueProp.attrState != null) {
                this.enqueueProp.attrState.applyGlobal();
            }
            if (this.vertArray.materialProp.attrState != null) {
                this.vertArray.materialProp.attrState.applyGlobal();
            }
            this.vertArray.mapping.applyToggleableAttr(this.enqueueProp.attrState, this.vertArray.materialProp.attrState);
            this.vertArray.draw();
        }
    }
}

