/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcer.model;

import forge.cn.zbx1425.sowcer.model.Mesh;
import forge.cn.zbx1425.sowcer.model.Model;
import forge.cn.zbx1425.sowcer.object.InstanceBuf;
import forge.cn.zbx1425.sowcer.object.VertArray;
import forge.cn.zbx1425.sowcer.vertex.VertAttrMapping;
import java.io.Closeable;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;

public class VertArrays
implements Closeable {
    public final ArrayList<VertArray> meshList = new ArrayList();

    public static VertArrays createAll(Model model, VertAttrMapping mapping, InstanceBuf instanceBuf) {
        VertArrays result = new VertArrays();
        for (Mesh mesh : model.meshList) {
            VertArray meshVertArray = new VertArray();
            meshVertArray.create(mesh, mapping, instanceBuf);
            result.meshList.add(meshVertArray);
        }
        return result;
    }

    public void replaceTexture(String oldTexture, ResourceLocation newTexture) {
        for (VertArray vertArray : this.meshList) {
            String oldPath;
            if (vertArray.materialProp.texture == null || !(oldPath = vertArray.materialProp.texture.m_135815_()).substring(oldPath.lastIndexOf("/") + 1).equals(oldTexture)) continue;
            vertArray.materialProp.texture = newTexture;
        }
    }

    public void replaceAllTexture(ResourceLocation newTexture) {
        for (VertArray vertArray : this.meshList) {
            vertArray.materialProp.texture = newTexture;
        }
    }

    public VertArrays copyForMaterialChanges() {
        VertArrays result = new VertArrays();
        for (VertArray vertArray : this.meshList) {
            VertArray newVertArray = vertArray.copyForMaterialChanges();
            result.meshList.add(newVertArray);
        }
        return result;
    }

    @Override
    public void close() {
        for (VertArray mesh : this.meshList) {
            mesh.close();
        }
    }
}

