/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcer.shader;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.sowcer.ContextCapability;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

public class PatchingResourceProvider
implements ResourceProvider {
    private final ResourceProvider source;

    public PatchingResourceProvider(ResourceProvider source) {
        this.source = source;
    }

    public Optional<Resource> m_213713_(ResourceLocation resourceLocation) {
        try {
            Optional srcResource;
            if (resourceLocation.m_135815_().contains("_modelmat")) {
                resourceLocation = new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().replace("_modelmat", ""));
            }
            if ((srcResource = this.source.m_213713_(resourceLocation)).isEmpty()) {
                return Optional.empty();
            }
            InputStream srcInputStream = ((Resource)srcResource.get()).m_215507_();
            String returningContent = "";
            if (resourceLocation.m_135815_().endsWith(".json")) {
                srcContent = IOUtils.toString((InputStream)srcInputStream, (Charset)StandardCharsets.UTF_8);
                JsonObject data = Main.JSON_PARSER.parse(srcContent).getAsJsonObject();
                data.addProperty("vertex", data.get("vertex").getAsString() + "_modelmat");
                JsonArray attribArray = data.get("attributes").getAsJsonArray();
                int dummyAttribCount = 6 - attribArray.size();
                for (int i = 0; i < dummyAttribCount; ++i) {
                    attribArray.add("Dummy" + i);
                }
                attribArray.add("ModelMat");
                returningContent = data.toString();
                srcInputStream.close();
            } else if (resourceLocation.m_135815_().endsWith(".vsh")) {
                srcContent = IOUtils.toString((InputStream)srcInputStream, (Charset)StandardCharsets.UTF_8);
                returningContent = PatchingResourceProvider.patchVertexShaderSource(srcContent);
                srcInputStream.close();
            } else {
                return srcResource;
            }
            ByteArrayInputStream newContentStream = new ByteArrayInputStream(returningContent.getBytes(StandardCharsets.UTF_8));
            return Optional.of(new Resource(((Resource)srcResource.get()).m_247173_(), () -> newContentStream));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    public static String patchVertexShaderSource(String srcContent) {
        String[] contentParts = srcContent.split("void main");
        contentParts[0] = contentParts[0].replace("uniform mat4 ModelViewMat;", "uniform mat4 ModelViewMat;\nin mat4 ModelMat;");
        if (ContextCapability.isGL4ES) {
            contentParts[0] = contentParts[0].replace("ivec2", "vec2");
        }
        contentParts[1] = contentParts[1].replaceAll("\\bPosition\\b", "(MODELVIEWMAT * ModelMat * vec4(Position, 1.0)).xyz").replaceAll("\\bNormal\\b", "normalize(mat3(MODELVIEWMAT * ModelMat) * Normal)").replace("ModelViewMat", "mat4(1.0)").replace("MODELVIEWMAT", "ModelViewMat");
        return contentParts[0] + "void main" + contentParts[1];
    }
}

