/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcer.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class OffHeapAllocator {
    private static final MemoryUtil.MemoryAllocator ALLOCATOR = MemoryUtil.getAllocator((boolean)false);

    public static ByteBuffer allocate(int size) {
        long ptr = ALLOCATOR.malloc((long)size);
        if (ptr == 0L) {
            throw new OutOfMemoryError();
        }
        return MemoryUtil.memByteBuffer((long)ptr, (int)size);
    }

    public static ByteBuffer resize(ByteBuffer buf, int byteSize) {
        long ptr = ALLOCATOR.realloc(MemoryUtil.memAddress0((Buffer)buf), (long)byteSize);
        if (ptr == 0L) {
            throw new OutOfMemoryError();
        }
        return MemoryUtil.memByteBuffer((long)ptr, (int)byteSize);
    }

    public static void free(ByteBuffer buf) {
        long ptr = MemoryUtil.memAddress0((Buffer)buf);
        ALLOCATOR.free(ptr);
    }
}

