/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcer.vertex;

import com.mojang.blaze3d.systems.RenderSystem;
import forge.cn.zbx1425.mtrsteamloco.render.ShadersModHandler;
import forge.cn.zbx1425.sowcer.ContextCapability;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcer.util.AttrUtil;
import forge.cn.zbx1425.sowcer.vertex.VertAttrType;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Objects;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.lwjgl.opengl.GL33;

public class VertAttrState {
    public Vector3f position;
    public Integer color;
    public Float texU;
    public Float texV;
    public Integer overlayUV;
    public Integer lightmapUV;
    public Vector3f normal;
    public Matrix4f matrixModel;

    public void applyGlobal() {
        block9: for (VertAttrType attr : VertAttrType.values()) {
            switch (attr) {
                case POSITION: {
                    if (this.position == null) continue block9;
                    GL33.glVertexAttrib3f((int)attr.location, (float)this.position.x(), (float)this.position.y(), (float)this.position.z());
                    continue block9;
                }
                case COLOR: {
                    if (this.color == null) continue block9;
                    GL33.glVertexAttrib4f((int)attr.location, (float)((float)(this.color >>> 24 & 0xFF) / 255.0f), (float)((float)(this.color >>> 16 & 0xFF) / 255.0f), (float)((float)(this.color >>> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f));
                    continue block9;
                }
                case UV_TEXTURE: {
                    if (this.texU == null || this.texV == null) continue block9;
                    GL33.glVertexAttrib2f((int)attr.location, (float)this.texU.floatValue(), (float)this.texV.floatValue());
                    continue block9;
                }
                case UV_OVERLAY: {
                    if (this.overlayUV == null) continue block9;
                    if (!ContextCapability.isGL4ES) {
                        GL33.glVertexAttribI2i((int)attr.location, (int)((short)(this.overlayUV >>> 16)), (int)((short)this.overlayUV.intValue()));
                        continue block9;
                    }
                    GL33.glVertexAttrib2f((int)attr.location, (float)((short)(this.overlayUV >>> 16)), (float)((short)this.overlayUV.intValue()));
                    continue block9;
                }
                case UV_LIGHTMAP: {
                    if (this.lightmapUV == null) continue block9;
                    if (!ContextCapability.isGL4ES) {
                        GL33.glVertexAttribI2i((int)attr.location, (int)((short)(this.lightmapUV >>> 16)), (int)((short)this.lightmapUV.intValue()));
                        continue block9;
                    }
                    GL33.glVertexAttrib2f((int)attr.location, (float)((short)(this.lightmapUV >>> 16)), (float)((short)this.lightmapUV.intValue()));
                    continue block9;
                }
                case NORMAL: {
                    if (this.normal == null) continue block9;
                    GL33.glVertexAttrib3f((int)attr.location, (float)this.normal.x(), (float)this.normal.y(), (float)this.normal.z());
                    continue block9;
                }
                case MATRIX_MODEL: {
                    if (this.matrixModel == null) continue block9;
                    boolean useCustomShader = ShadersModHandler.canUseCustomShader();
                    if (useCustomShader) {
                        ByteBuffer byteBuf = ByteBuffer.allocate(64);
                        FloatBuffer floatBuf = byteBuf.asFloatBuffer();
                        this.matrixModel.store(floatBuf);
                        GL33.glVertexAttrib4f((int)attr.location, (float)floatBuf.get(0), (float)floatBuf.get(1), (float)floatBuf.get(2), (float)floatBuf.get(3));
                        GL33.glVertexAttrib4f((int)(attr.location + 1), (float)floatBuf.get(4), (float)floatBuf.get(5), (float)floatBuf.get(6), (float)floatBuf.get(7));
                        GL33.glVertexAttrib4f((int)(attr.location + 2), (float)floatBuf.get(8), (float)floatBuf.get(9), (float)floatBuf.get(10), (float)floatBuf.get(11));
                        GL33.glVertexAttrib4f((int)(attr.location + 3), (float)floatBuf.get(12), (float)floatBuf.get(13), (float)floatBuf.get(14), (float)floatBuf.get(15));
                        continue block9;
                    }
                    ShaderInstance shaderInstance = RenderSystem.m_157196_();
                    if (shaderInstance == null || shaderInstance.f_173308_ == null) continue block9;
                    shaderInstance.f_173308_.m_5679_(this.matrixModel.asMoj());
                    if (ShadersModHandler.canUseCustomShader()) {
                        shaderInstance.f_173308_.m_85633_();
                        continue block9;
                    }
                    shaderInstance.m_173363_();
                }
            }
        }
    }

    public VertAttrState setPosition(Vector3f position) {
        this.position = position;
        return this;
    }

    public VertAttrState setColor(int r, int g, int b, int a) {
        this.color = r << 24 | g << 16 | b << 8 | a;
        return this;
    }

    public VertAttrState setColor(int rgba) {
        this.color = rgba;
        return this;
    }

    public VertAttrState setTextureUV(float u, float v) {
        this.texU = Float.valueOf(u);
        this.texV = Float.valueOf(v);
        return this;
    }

    public VertAttrState setLightmapUV(short u, short v) {
        this.lightmapUV = u << 16 | v;
        return this;
    }

    public VertAttrState setOverlayUV(int uv) {
        this.overlayUV = uv;
        return this;
    }

    public VertAttrState setOverlayUVNoOverlay() {
        this.overlayUV = AttrUtil.exchangeLightmapUVBits(OverlayTexture.f_118083_);
        return this;
    }

    public VertAttrState setLightmapUV(int uv) {
        this.lightmapUV = uv;
        return this;
    }

    public VertAttrState setNormal(Vector3f position) {
        this.normal = position;
        return this;
    }

    public VertAttrState setModelMatrix(Matrix4f matrix) {
        this.matrixModel = matrix;
        return this;
    }

    public boolean hasAttr(VertAttrType attrType) {
        switch (attrType) {
            case POSITION: {
                return this.position != null;
            }
            case COLOR: {
                return this.color != null;
            }
            case NORMAL: {
                return this.normal != null;
            }
            case UV_OVERLAY: {
                return this.overlayUV != null;
            }
            case UV_TEXTURE: {
                return this.texU != null && this.texV != null;
            }
            case UV_LIGHTMAP: {
                return this.lightmapUV != null;
            }
            case MATRIX_MODEL: {
                return this.matrixModel != null;
            }
        }
        return false;
    }

    public void clearAttr(VertAttrType attrType) {
        switch (attrType) {
            case POSITION: {
                this.position = null;
                break;
            }
            case COLOR: {
                this.color = null;
                break;
            }
            case NORMAL: {
                this.normal = null;
                break;
            }
            case UV_OVERLAY: {
                this.overlayUV = null;
                break;
            }
            case UV_TEXTURE: {
                this.texU = null;
                this.texV = null;
                break;
            }
            case UV_LIGHTMAP: {
                this.lightmapUV = null;
                break;
            }
            case MATRIX_MODEL: {
                this.matrixModel = null;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertAttrState that = (VertAttrState)o;
        return Objects.equals(this.position, that.position) && Objects.equals(this.color, that.color) && Objects.equals(this.texU, that.texU) && Objects.equals(this.texV, that.texV) && Objects.equals(this.lightmapUV, that.lightmapUV) && Objects.equals(this.normal, that.normal) && Objects.equals(this.matrixModel, that.matrixModel);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.color, this.texU, this.texV, this.lightmapUV, this.normal, this.matrixModel);
    }

    public VertAttrState copy() {
        VertAttrState clone = new VertAttrState();
        clone.position = this.position == null ? null : this.position.copy();
        clone.color = this.color;
        clone.texU = this.texU;
        clone.texV = this.texV;
        clone.lightmapUV = this.lightmapUV;
        clone.normal = this.normal == null ? null : this.normal.copy();
        clone.matrixModel = this.matrixModel == null ? null : this.matrixModel.copy();
        return clone;
    }
}

