/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcerext.model.integration;

import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcerext.model.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class FaceList {
    private final RenderType renderType;
    private final boolean needSorting;
    private final List<TransformedFace> queuedFaces = new ArrayList<TransformedFace>();

    public FaceList(RenderType renderType, boolean needSorting) {
        this.renderType = renderType;
        this.needSorting = needSorting;
    }

    public void addFace(Vertex[] vertices, int color, int light) {
        this.queuedFaces.add(new TransformedFace(vertices, color, light));
    }

    public void commit(MultiBufferSource bufferSource) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.renderType);
        if (this.needSorting) {
            this.queuedFaces.sort((a, b) -> -Float.compare(a.sortingVector.distanceSq(Vector3f.ZERO), b.sortingVector.distanceSq(Vector3f.ZERO)));
        }
        for (TransformedFace face : this.queuedFaces) {
            for (Vertex vertex : face.vertices) {
                vertexConsumer.m_5483_((double)vertex.position.x(), (double)vertex.position.y(), (double)vertex.position.z()).m_6122_((int)((byte)(face.color >>> 24)), (int)((byte)(face.color >>> 16)), (int)((byte)(face.color >>> 8)), (int)((byte)face.color)).m_7421_(vertex.u, vertex.v).m_86008_(OverlayTexture.f_118083_).m_85969_(face.light).m_5601_(vertex.normal.x(), vertex.normal.y(), vertex.normal.z()).m_5752_();
            }
        }
    }

    private static class TransformedFace {
        private final Vertex[] vertices;
        private final Vector3f sortingVector;
        int color;
        int light;

        public TransformedFace(Vertex[] vertices, int color, int light) {
            this.vertices = vertices;
            this.sortingVector = new Vector3f(0.0f, 0.0f, 0.0f);
            for (Vertex vertex : vertices) {
                this.sortingVector.add(vertex.position);
            }
            this.color = color;
            this.light = light;
        }
    }
}

