/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcerext.multipart.mi;

import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.math.Vector3f;
import forge.cn.zbx1425.sowcerext.model.ModelCluster;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import forge.cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import forge.cn.zbx1425.sowcerext.multipart.PartBase;
import forge.cn.zbx1425.sowcerext.reuse.ModelManager;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class MiPart
extends PartBase {
    private ModelCluster model = null;
    public String name;
    public Vector3f internalOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f externalOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    public FloatSpline translateX = new FloatSpline();
    public FloatSpline translateY = new FloatSpline();
    public FloatSpline translateZ = new FloatSpline();
    public FloatSpline rotateX = new FloatSpline();
    public FloatSpline rotateY = new FloatSpline();
    public FloatSpline rotateZ = new FloatSpline();
    private Matrix4f lastTransform = null;
    private boolean isVisible = true;

    public void setModel(RawModel rawModel, ModelManager modelManager) {
        this.model = rawModel == null ? null : modelManager.uploadVertArrays(rawModel);
    }

    @Override
    public void update(MultipartUpdateProp prop) {
        Matrix4f result = new Matrix4f();
        float time = prop.miKeyframeTime;
        result.translate(this.externalOffset.x(), this.externalOffset.y(), this.externalOffset.z());
        result.translate(this.translateX.getValue(time), this.translateY.getValue(time), this.translateZ.getValue(time));
        if (this.parent != null) {
            result.multiply(this.parent.getTransform(prop));
        }
        result.translate(this.internalOffset.x(), this.internalOffset.y(), this.internalOffset.z());
        result.rotateX(this.rotateX.getValue(time));
        result.rotateY(this.rotateY.getValue(time));
        result.rotateZ(this.rotateZ.getValue(time));
        this.lastTransform = result;
        this.isVisible = prop.miHiddenParts == null || !prop.miHiddenParts.contains(this.name) && (this.parent == null || ((MiPart)this.parent).isVisible);
    }

    @Override
    public ModelCluster getModel(MultipartUpdateProp prop) {
        return this.isVisible ? this.model : null;
    }

    @Override
    public Matrix4f getTransform(MultipartUpdateProp prop) {
        return this.lastTransform;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    public static class FloatSpline {
        public TreeMap<Float, Float> spline = new TreeMap();

        public float getValue(float key) {
            if (this.spline.size() < 1) {
                return 0.0f;
            }
            Map.Entry<Float, Float> floorEntry = this.spline.floorEntry(Float.valueOf(key));
            Map.Entry<Float, Float> ceilingEntry = this.spline.ceilingEntry(Float.valueOf(key));
            if (floorEntry == null) {
                return ceilingEntry.getValue().floatValue();
            }
            if (ceilingEntry == null) {
                return floorEntry.getValue().floatValue();
            }
            if (Objects.equals(floorEntry.getKey(), ceilingEntry.getKey())) {
                return floorEntry.getValue().floatValue();
            }
            return floorEntry.getValue().floatValue() + (ceilingEntry.getValue().floatValue() - floorEntry.getValue().floatValue()) * ((key - floorEntry.getKey().floatValue()) / (ceilingEntry.getKey().floatValue() - floorEntry.getKey().floatValue()));
        }
    }
}

