/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcerext.reuse;

import forge.cn.zbx1425.sowcer.batch.BatchManager;
import forge.cn.zbx1425.sowcer.math.Matrix4f;
import forge.cn.zbx1425.sowcer.shader.ShaderManager;
import forge.cn.zbx1425.sowcer.util.DrawContext;
import forge.cn.zbx1425.sowcer.util.GlStateTracker;
import forge.cn.zbx1425.sowcerext.model.ModelCluster;
import forge.cn.zbx1425.sowcerext.model.integration.BufferSourceProxy;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.server.packs.resources.ResourceManager;

public class DrawScheduler {
    public final BatchManager batchManager = new BatchManager();
    public final ShaderManager shaderManager = new ShaderManager();
    private final List<ClusterDrawCall> drawCalls = new LinkedList<ClusterDrawCall>();

    public void reloadShaders(ResourceManager resourceManager) throws IOException {
        this.shaderManager.reloadShaders(resourceManager);
    }

    public void enqueue(ModelCluster model, Matrix4f pose, int light) {
        this.drawCalls.add(new ClusterDrawCall(model, pose, light));
    }

    public void commit(BufferSourceProxy vertexConsumers, DrawContext drawContext) {
        if (!drawContext.drawWithBlaze && !this.shaderManager.isReady()) {
            return;
        }
        if (this.drawCalls.isEmpty()) {
            return;
        }
        if (drawContext.drawWithBlaze) {
            for (ClusterDrawCall drawCall : this.drawCalls) {
                drawCall.model.enqueueOpaqueBlaze(vertexConsumers, drawCall.pose, drawCall.light, drawContext);
            }
        } else {
            for (ClusterDrawCall drawCall : this.drawCalls) {
                drawCall.model.enqueueOpaqueGl(this.batchManager, drawCall.pose, drawCall.light, drawContext);
            }
        }
        if (drawContext.drawWithBlaze || drawContext.sortTranslucentFaces) {
            for (ClusterDrawCall drawCall : this.drawCalls) {
                drawCall.model.enqueueTranslucentBlaze(vertexConsumers, drawCall.pose, drawCall.light, drawContext);
            }
        } else {
            for (ClusterDrawCall drawCall : this.drawCalls) {
                drawCall.model.enqueueTranslucentGl(this.batchManager, drawCall.pose, drawCall.light, drawContext);
            }
        }
        if (!drawContext.drawWithBlaze) {
            GlStateTracker.capture();
            this.commitRaw(drawContext);
            GlStateTracker.restore();
        }
        this.drawCalls.clear();
    }

    public void commitRaw(DrawContext drawContext) {
        this.batchManager.drawAll(this.shaderManager, drawContext);
    }

    private static class ClusterDrawCall {
        public ModelCluster model;
        public Matrix4f pose;
        public int light;

        public ClusterDrawCall(ModelCluster model, Matrix4f pose, int light) {
            this.model = model;
            this.pose = pose;
            this.light = light;
        }
    }
}

