/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcerext.reuse;

import forge.cn.zbx1425.sowcer.model.Model;
import forge.cn.zbx1425.sowcer.vertex.VertAttrMapping;
import forge.cn.zbx1425.sowcer.vertex.VertAttrSrc;
import forge.cn.zbx1425.sowcer.vertex.VertAttrType;
import forge.cn.zbx1425.sowcerext.model.ModelCluster;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import forge.cn.zbx1425.sowcerext.model.loader.CsvModelLoader;
import forge.cn.zbx1425.sowcerext.model.loader.NmbModelLoader;
import forge.cn.zbx1425.sowcerext.model.loader.ObjModelLoader;
import forge.cn.zbx1425.sowcerext.reuse.AtlasManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FilenameUtils;

public class ModelManager {
    public HashMap<ResourceLocation, Model> uploadedModels = new HashMap();
    public HashMap<ResourceLocation, ModelCluster> uploadedVertArrays = new HashMap();
    public HashMap<ResourceLocation, RawModel> loadedRawModels = new HashMap();
    public int vaoCount;
    public int vboCount;
    public static final VertAttrMapping DEFAULT_MAPPING = new VertAttrMapping.Builder().set(VertAttrType.POSITION, VertAttrSrc.VERTEX_BUF).set(VertAttrType.COLOR, VertAttrSrc.GLOBAL).set(VertAttrType.UV_TEXTURE, VertAttrSrc.VERTEX_BUF).set(VertAttrType.UV_OVERLAY, VertAttrSrc.GLOBAL).set(VertAttrType.UV_LIGHTMAP, VertAttrSrc.GLOBAL).set(VertAttrType.NORMAL, VertAttrSrc.VERTEX_BUF).set(VertAttrType.MATRIX_MODEL, VertAttrSrc.GLOBAL).build();

    public void clear() {
        this.vaoCount = 0;
        for (ModelCluster vertArrays : this.uploadedVertArrays.values()) {
            vertArrays.close();
        }
        this.uploadedVertArrays.clear();
        this.vboCount = 0;
        for (Model model : this.uploadedModels.values()) {
            model.close();
        }
        this.uploadedModels.clear();
        this.loadedRawModels.clear();
    }

    public void clearNamespace(String namespace) {
        this.uploadedVertArrays.entrySet().stream().filter(k -> ((ResourceLocation)k.getKey()).m_135827_().equals(namespace)).forEach(k -> {
            this.vaoCount -= ((ModelCluster)k.getValue()).uploadedOpaqueParts == null ? 0 : ((ModelCluster)k.getValue()).uploadedOpaqueParts.meshList.size();
            ((ModelCluster)k.getValue()).close();
        });
        this.uploadedVertArrays.keySet().removeIf(k -> k.m_135827_().equals(namespace));
        this.uploadedModels.entrySet().stream().filter(k -> ((ResourceLocation)k.getKey()).m_135827_().equals(namespace)).forEach(k -> {
            this.vboCount -= ((Model)k.getValue()).meshList.size();
            ((Model)k.getValue()).close();
        });
        this.uploadedModels.keySet().removeIf(k -> k.m_135827_().equals(namespace));
        this.loadedRawModels.keySet().removeIf(k -> k.m_135827_().equals(namespace));
    }

    public RawModel loadRawModel(ResourceManager resourceManager, ResourceLocation objLocation, AtlasManager atlasManager) throws IOException {
        String crntStatExt;
        if (this.loadedRawModels.containsKey(objLocation)) {
            return this.loadedRawModels.get(objLocation);
        }
        RawModel result = switch (crntStatExt = FilenameUtils.getExtension((String)objLocation.m_135815_())) {
            case "obj" -> ObjModelLoader.loadModel(resourceManager, objLocation, atlasManager);
            case "csv" -> CsvModelLoader.loadModel(resourceManager, objLocation, atlasManager);
            case "nmb" -> NmbModelLoader.loadModel(resourceManager, objLocation, atlasManager);
            case "animated" -> throw new IllegalArgumentException("ANIMATED model cannot be loaded as RawModel.");
            default -> throw new IllegalArgumentException("Unknown model format: " + resourceManager);
        };
        this.loadedRawModels.put(objLocation, result);
        return result;
    }

    public Map<String, RawModel> loadPartedRawModel(ResourceManager resourceManager, ResourceLocation objLocation, AtlasManager atlasManager) throws IOException {
        String crntStatExt;
        return switch (crntStatExt = FilenameUtils.getExtension((String)objLocation.m_135815_())) {
            case "obj" -> ObjModelLoader.loadModels(resourceManager, objLocation, atlasManager);
            case "csv", "nmb" -> throw new IllegalArgumentException("CSV/NMB model cannot be loaded as parted RawModel.");
            case "animated" -> throw new IllegalArgumentException("ANIMATED model cannot be loaded as RawModel.");
            default -> throw new IllegalArgumentException("Unknown model format: " + resourceManager);
        };
    }

    public Model uploadModel(RawModel rawModel) {
        if (rawModel.sourceLocation == null) {
            Model result = rawModel.upload(DEFAULT_MAPPING);
            this.vboCount += result.meshList.size();
            this.uploadedModels.put(new ResourceLocation("sowcerext-anonymous:model/" + UUID.randomUUID()), result);
            return result;
        }
        if (this.uploadedModels.containsKey(rawModel.sourceLocation)) {
            return this.uploadedModels.get(rawModel.sourceLocation);
        }
        Model result = rawModel.upload(DEFAULT_MAPPING);
        this.vboCount += result.meshList.size();
        this.uploadedModels.put(rawModel.sourceLocation, result);
        return result;
    }

    public ModelCluster uploadVertArrays(RawModel rawModel) {
        if (rawModel.sourceLocation == null) {
            ModelCluster result = new ModelCluster(rawModel, DEFAULT_MAPPING, this);
            this.vaoCount += result.uploadedOpaqueParts == null ? 0 : result.uploadedOpaqueParts.meshList.size();
            this.uploadedVertArrays.put(new ResourceLocation("sowcerext-anonymous:vertarrays/" + UUID.randomUUID()), result);
            return result;
        }
        if (this.uploadedVertArrays.containsKey(rawModel.sourceLocation)) {
            return this.uploadedVertArrays.get(rawModel.sourceLocation);
        }
        ModelCluster result = new ModelCluster(rawModel, DEFAULT_MAPPING, this);
        this.vaoCount += result.uploadedOpaqueParts == null ? 0 : result.uploadedOpaqueParts.meshList.size();
        this.uploadedVertArrays.put(rawModel.sourceLocation, result);
        return result;
    }
}

