/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.sowcerext.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.List;
import java.util.Locale;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;

public class ResourceUtil {
    public static String readResource(ResourceManager manager, ResourceLocation location) throws IOException {
        List resources = UtilitiesClient.getResources((ResourceManager)manager, (ResourceLocation)location);
        if (resources.isEmpty()) {
            return "";
        }
        return IOUtils.toString((InputStream)new BOMInputStream(Utilities.getInputStream((Resource)((Resource)resources.get(0)))), (Charset)StandardCharsets.UTF_8);
    }

    public static ResourceLocation resolveRelativePath(ResourceLocation baseFile, String relative, String expectExtension) {
        if (((String)(relative = ((String)relative).toLowerCase(Locale.ROOT).replace('\\', '/'))).contains(":")) {
            relative = ((String)relative).replaceAll("[^a-z0-9/.:_-]", "_");
            return new ResourceLocation((String)relative);
        }
        if (((String)(relative = ((String)relative).replaceAll("[^a-z0-9/._-]", "_"))).endsWith(".jpg") || ((String)relative).endsWith(".bmp") || ((String)relative).endsWith(".tga")) {
            relative = ((String)relative).substring(0, ((String)relative).length() - 4) + ".png";
        }
        if (expectExtension != null && !((String)relative).endsWith(expectExtension)) {
            relative = (String)relative + expectExtension;
        }
        String resolvedPath = FileSystems.getDefault().getPath(baseFile.m_135815_(), new String[0]).getParent().resolve((String)relative).normalize().toString().replace('\\', '/');
        return new ResourceLocation(baseFile.m_135827_(), resolvedPath);
    }
}

