/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript;

import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Constructable;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Context;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptRuntime;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Scriptable;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptableObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Symbol;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.SymbolKey;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Undefined;

class AbstractEcmaObjectOperations {
    AbstractEcmaObjectOperations() {
    }

    static boolean hasOwnProperty(Context cx, Object o, Object property) {
        boolean result;
        Scriptable obj = ScriptableObject.ensureScriptable(o);
        if (property instanceof Symbol) {
            result = ScriptableObject.ensureSymbolScriptable(o).has((Symbol)property, obj);
        } else {
            ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(property);
            result = s.stringId == null ? obj.has(s.index, obj) : obj.has(s.stringId, obj);
        }
        return result;
    }

    static boolean testIntegrityLevel(Context cx, Object o, INTEGRITY_LEVEL level) {
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        if (obj.isExtensible()) {
            return false;
        }
        for (Object name : obj.getIds(true, true)) {
            ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, name);
            if (Boolean.TRUE.equals(desc.get("configurable"))) {
                return false;
            }
            if (level != INTEGRITY_LEVEL.FROZEN || !ScriptableObject.isDataDescriptor(desc) || !Boolean.TRUE.equals(desc.get("writable"))) continue;
            return false;
        }
        return true;
    }

    static boolean setIntegrityLevel(Context cx, Object o, INTEGRITY_LEVEL level) {
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        obj.preventExtensions();
        for (Object key : obj.getIds(true, true)) {
            ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, key);
            if (level == INTEGRITY_LEVEL.SEALED) {
                if (!Boolean.TRUE.equals(desc.get("configurable"))) continue;
                desc.put("configurable", (Scriptable)desc, (Object)Boolean.FALSE);
                obj.defineOwnProperty(cx, key, desc, false);
                continue;
            }
            if (ScriptableObject.isDataDescriptor(desc) && Boolean.TRUE.equals(desc.get("writable"))) {
                desc.put("writable", (Scriptable)desc, (Object)Boolean.FALSE);
            }
            if (Boolean.TRUE.equals(desc.get("configurable"))) {
                desc.put("configurable", (Scriptable)desc, (Object)Boolean.FALSE);
            }
            obj.defineOwnProperty(cx, key, desc, false);
        }
        return true;
    }

    static Constructable speciesConstructor(Context cx, Scriptable s, Constructable defaultConstructor) {
        Object constructor = ScriptableObject.getProperty(s, "constructor");
        if (constructor == Scriptable.NOT_FOUND || Undefined.isUndefined(constructor)) {
            return defaultConstructor;
        }
        if (!ScriptRuntime.isObject(constructor)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(constructor));
        }
        Object species = ScriptableObject.getProperty((Scriptable)constructor, SymbolKey.SPECIES);
        if (species == Scriptable.NOT_FOUND || species == null || Undefined.isUndefined(species)) {
            return defaultConstructor;
        }
        if (!(species instanceof Constructable)) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", ScriptRuntime.typeof(species));
        }
        return (Constructable)species;
    }

    static void put(Context cx, Scriptable o, String p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putImpl(p, 0, o, v, isThrow)) {
                return;
            }
            o.put(p, o, v);
        } else {
            base.put(p, o, v);
        }
    }

    static void put(Context cx, Scriptable o, int p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putImpl(null, p, o, v, isThrow)) {
                return;
            }
            o.put(p, o, v);
        } else {
            base.put(p, o, v);
        }
    }

    static enum INTEGRITY_LEVEL {
        FROZEN,
        SEALED;

    }
}

