/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript;

import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Context;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.IdFunctionObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.IdScriptableObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptStackElement;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Scriptable;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Undefined;

public class NativeCallSite
extends IdScriptableObject {
    private static final long serialVersionUID = 2688372752566593594L;
    private static final String CALLSITE_TAG = "CallSite";
    private ScriptStackElement element;
    private static final int Id_constructor = 1;
    private static final int Id_getThis = 2;
    private static final int Id_getTypeName = 3;
    private static final int Id_getFunction = 4;
    private static final int Id_getFunctionName = 5;
    private static final int Id_getMethodName = 6;
    private static final int Id_getFileName = 7;
    private static final int Id_getLineNumber = 8;
    private static final int Id_getColumnNumber = 9;
    private static final int Id_getEvalOrigin = 10;
    private static final int Id_isToplevel = 11;
    private static final int Id_isEval = 12;
    private static final int Id_isNative = 13;
    private static final int Id_isConstructor = 14;
    private static final int Id_toString = 15;
    private static final int MAX_PROTOTYPE_ID = 15;

    static void init(Scriptable scope, boolean sealed) {
        NativeCallSite cs = new NativeCallSite();
        cs.exportAsJSClass(15, scope, sealed);
    }

    static NativeCallSite make(Scriptable scope, Scriptable ctorObj) {
        NativeCallSite cs = new NativeCallSite();
        Scriptable proto = (Scriptable)ctorObj.get("prototype", ctorObj);
        cs.setParentScope(scope);
        cs.setPrototype(proto);
        return cs;
    }

    private NativeCallSite() {
    }

    void setElement(ScriptStackElement elt) {
        this.element = elt;
    }

    @Override
    public String getClassName() {
        return CALLSITE_TAG;
    }

    @Override
    protected void initPrototypeId(int id) {
        int arity;
        this.initPrototypeMethod(CALLSITE_TAG, id, switch (id) {
            case 1 -> {
                arity = 0;
                yield "constructor";
            }
            case 2 -> {
                arity = 0;
                yield "getThis";
            }
            case 3 -> {
                arity = 0;
                yield "getTypeName";
            }
            case 4 -> {
                arity = 0;
                yield "getFunction";
            }
            case 5 -> {
                arity = 0;
                yield "getFunctionName";
            }
            case 6 -> {
                arity = 0;
                yield "getMethodName";
            }
            case 7 -> {
                arity = 0;
                yield "getFileName";
            }
            case 8 -> {
                arity = 0;
                yield "getLineNumber";
            }
            case 9 -> {
                arity = 0;
                yield "getColumnNumber";
            }
            case 10 -> {
                arity = 0;
                yield "getEvalOrigin";
            }
            case 11 -> {
                arity = 0;
                yield "isToplevel";
            }
            case 12 -> {
                arity = 0;
                yield "isEval";
            }
            case 13 -> {
                arity = 0;
                yield "isNative";
            }
            case 14 -> {
                arity = 0;
                yield "isConstructor";
            }
            case 15 -> {
                arity = 0;
                yield "toString";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(CALLSITE_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                return NativeCallSite.make(scope, f);
            }
            case 5: {
                return NativeCallSite.getFunctionName(thisObj);
            }
            case 7: {
                return NativeCallSite.getFileName(thisObj);
            }
            case 8: {
                return NativeCallSite.getLineNumber(thisObj);
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                return Undefined.instance;
            }
            case 6: {
                return null;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return Boolean.FALSE;
            }
            case 15: {
                return NativeCallSite.js_toString(thisObj);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public String toString() {
        if (this.element == null) {
            return "";
        }
        return this.element.toString();
    }

    private static Object js_toString(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        StringBuilder sb = new StringBuilder();
        cs.element.renderJavaStyle(sb);
        return sb.toString();
    }

    private static Object getFunctionName(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        return cs.element == null ? null : cs.element.functionName;
    }

    private static Object getFileName(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        return cs.element == null ? null : cs.element.fileName;
    }

    private static Object getLineNumber(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        if (cs.element == null || cs.element.lineNumber < 0) {
            return Undefined.instance;
        }
        return cs.element.lineNumber;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "getThis" -> 2;
            case "getTypeName" -> 3;
            case "getFunction" -> 4;
            case "getFunctionName" -> 5;
            case "getMethodName" -> 6;
            case "getFileName" -> 7;
            case "getLineNumber" -> 8;
            case "getColumnNumber" -> 9;
            case "getEvalOrigin" -> 10;
            case "isToplevel" -> 11;
            case "isEval" -> 12;
            case "isNative" -> 13;
            case "isConstructor" -> 14;
            case "toString" -> 15;
            default -> 0;
        };
    }
}

