/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.BaseFunction;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Callable;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ConsString;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Context;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Delegator;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.EcmaError;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.EvaluatorException;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.IdFunctionObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.IdScriptableObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.NativeJSON;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptRuntime;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptStackElement;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Scriptable;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptableObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Undefined;

public class NativeConsole
extends IdScriptableObject {
    private static final long serialVersionUID = 5694613212458273057L;
    private static final Object CONSOLE_TAG = "Console";
    private static final String DEFAULT_LABEL = "default";
    private static final Pattern FMT_REG = Pattern.compile("%[sfdioOc%]");
    private final Map<String, Long> timers = new ConcurrentHashMap<String, Long>();
    private final Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConsolePrinter printer;
    private static final int Id_toSource = 1;
    private static final int Id_trace = 2;
    private static final int Id_debug = 3;
    private static final int Id_log = 4;
    private static final int Id_info = 5;
    private static final int Id_warn = 6;
    private static final int Id_error = 7;
    private static final int Id_assert = 8;
    private static final int Id_count = 9;
    private static final int Id_countReset = 10;
    private static final int Id_time = 11;
    private static final int Id_timeEnd = 12;
    private static final int Id_timeLog = 13;
    private static final int LAST_METHOD_ID = 13;
    private static final int MAX_ID = 13;

    public static void init(Scriptable scope, boolean sealed, ConsolePrinter printer) {
        NativeConsole obj = new NativeConsole(printer);
        obj.activatePrototypeMap(13);
        obj.setPrototype(NativeConsole.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        ScriptableObject.defineProperty(scope, "console", obj, 2);
    }

    private NativeConsole(ConsolePrinter printer) {
        this.printer = printer;
    }

    @Override
    public String getClassName() {
        return "Console";
    }

    @Override
    protected void initPrototypeId(int id) {
        int arity;
        if (id > 13) {
            throw new IllegalStateException(String.valueOf(id));
        }
        this.initPrototypeMethod(CONSOLE_TAG, id, switch (id) {
            case 1 -> {
                arity = 0;
                yield "toSource";
            }
            case 2 -> {
                arity = 1;
                yield "trace";
            }
            case 3 -> {
                arity = 1;
                yield "debug";
            }
            case 4 -> {
                arity = 1;
                yield "log";
            }
            case 5 -> {
                arity = 1;
                yield "info";
            }
            case 6 -> {
                arity = 1;
                yield "warn";
            }
            case 7 -> {
                arity = 1;
                yield "error";
            }
            case 8 -> {
                arity = 2;
                yield "assert";
            }
            case 9 -> {
                arity = 1;
                yield "count";
            }
            case 10 -> {
                arity = 1;
                yield "countReset";
            }
            case 11 -> {
                arity = 1;
                yield "time";
            }
            case 12 -> {
                arity = 1;
                yield "timeEnd";
            }
            case 13 -> {
                arity = 2;
                yield "timeLog";
            }
            default -> throw new IllegalStateException(String.valueOf(id));
        }, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(CONSOLE_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int methodId = f.methodId();
        switch (methodId) {
            case 1: {
                return "Console";
            }
            case 2: {
                ScriptStackElement[] stack = new EvaluatorException("[object Object]").getScriptStack();
                this.printer.print(cx, scope, Level.TRACE, args, stack);
                break;
            }
            case 3: {
                this.printer.print(cx, scope, Level.DEBUG, args, null);
                break;
            }
            case 4: 
            case 5: {
                this.printer.print(cx, scope, Level.INFO, args, null);
                break;
            }
            case 6: {
                this.printer.print(cx, scope, Level.WARN, args, null);
                break;
            }
            case 7: {
                this.printer.print(cx, scope, Level.ERROR, args, null);
                break;
            }
            case 8: {
                this.jsAssert(cx, scope, args);
                break;
            }
            case 9: {
                this.count(cx, scope, args);
                break;
            }
            case 10: {
                this.countReset(cx, scope, args);
                break;
            }
            case 11: {
                this.time(cx, scope, args);
                break;
            }
            case 12: {
                this.timeEnd(cx, scope, args);
                break;
            }
            case 13: {
                this.timeLog(cx, scope, args);
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(methodId));
            }
        }
        return Undefined.instance;
    }

    private void print(Context cx, Scriptable scope, Level level, String msg) {
        this.printer.print(cx, scope, level, new String[]{msg}, null);
    }

    public static String format(Context cx, Scriptable scope, Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int argIndex = 0;
        Object first = args[0];
        if (first instanceof String || first instanceof ConsString) {
            String msg = first.toString();
            Matcher matcher = FMT_REG.matcher(msg);
            argIndex = 1;
            while (matcher.find()) {
                String replaceArg;
                String placeHolder = matcher.group();
                if (placeHolder.equals("%%")) {
                    replaceArg = "%";
                } else if (argIndex >= args.length) {
                    replaceArg = placeHolder;
                    ++argIndex;
                } else {
                    Object val = args[argIndex];
                    switch (placeHolder) {
                        case "%s": {
                            replaceArg = NativeConsole.formatString(val);
                            break;
                        }
                        case "%d": 
                        case "%i": {
                            replaceArg = NativeConsole.formatInt(val);
                            break;
                        }
                        case "%f": {
                            replaceArg = NativeConsole.formatFloat(val);
                            break;
                        }
                        case "%o": 
                        case "%O": {
                            replaceArg = NativeConsole.formatObj(cx, scope, val);
                            break;
                        }
                        default: {
                            replaceArg = "";
                        }
                    }
                    ++argIndex;
                }
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(replaceArg));
            }
            matcher.appendTail(buffer);
        }
        for (int i = argIndex; i < args.length; ++i) {
            Object val;
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            if ((val = args[i]) instanceof String) {
                buffer.append(NativeConsole.formatString(val));
                continue;
            }
            buffer.append(NativeConsole.formatObj(cx, scope, val));
        }
        return buffer.toString();
    }

    private static String formatString(Object val) {
        if (val instanceof BigInteger) {
            return ScriptRuntime.toString(val) + "n";
        }
        if (ScriptRuntime.isSymbol(val)) {
            return val.toString();
        }
        return ScriptRuntime.toString(val);
    }

    private static String formatInt(Object val) {
        if (val instanceof BigInteger) {
            return ScriptRuntime.bigIntToString((BigInteger)val, 10) + "n";
        }
        if (ScriptRuntime.isSymbol(val)) {
            return ScriptRuntime.NaNobj.toString();
        }
        double number = ScriptRuntime.toNumber(val);
        if (Double.isInfinite(number) || Double.isNaN(number)) {
            return ScriptRuntime.toString(number);
        }
        return String.valueOf((long)number);
    }

    private static String formatFloat(Object val) {
        if (val instanceof BigInteger || ScriptRuntime.isSymbol(val)) {
            return ScriptRuntime.NaNobj.toString();
        }
        return ScriptRuntime.numberToString(ScriptRuntime.toNumber(val), 10);
    }

    private static String formatObj(Context cx, Scriptable scope, Object arg) {
        if (arg == null) {
            return "null";
        }
        if (Undefined.isUndefined(arg)) {
            return Undefined.SCRIPTABLE_UNDEFINED.toString();
        }
        try {
            Callable replacer = new Callable(){

                @Override
                public Object call(Context callCx, Scriptable callScope, Scriptable callThisObj, Object[] callArgs) {
                    Object value = callArgs[1];
                    while (value instanceof Delegator) {
                        value = ((Delegator)value).getDelegee();
                    }
                    if (value instanceof BaseFunction) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("function ").append(((BaseFunction)value).getFunctionName()).append("() {...}");
                        return sb.toString();
                    }
                    if (value instanceof Callable) {
                        return ScriptRuntime.toString(value);
                    }
                    return value;
                }
            };
            Object stringify = NativeJSON.stringify(cx, scope, arg, replacer, null);
            return ScriptRuntime.toString(stringify);
        }
        catch (EcmaError e) {
            if ("TypeError".equals(e.getName())) {
                return ScriptRuntime.toString(arg);
            }
            throw e;
        }
    }

    private void jsAssert(Context cx, Scriptable scope, Object[] args) {
        if (args != null && args.length > 0 && ScriptRuntime.toBoolean(args[0])) {
            return;
        }
        if (args == null || args.length < 2) {
            this.printer.print(cx, scope, Level.ERROR, new String[]{"Assertion failed: console.assert"}, null);
            return;
        }
        Object first = args[1];
        if (first instanceof String) {
            args[1] = "Assertion failed: " + first;
            Object[] newArgs = new Object[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
            args = newArgs;
        } else {
            args[0] = "Assertion failed:";
        }
        this.printer.print(cx, scope, Level.ERROR, args, null);
    }

    private void count(Context cx, Scriptable scope, Object[] args) {
        String label = args.length > 0 ? ScriptRuntime.toString(args[0]) : DEFAULT_LABEL;
        int count = this.counters.computeIfAbsent(label, l -> new AtomicInteger(0)).incrementAndGet();
        this.print(cx, scope, Level.INFO, label + ": " + count);
    }

    private void countReset(Context cx, Scriptable scope, Object[] args) {
        String label = args.length > 0 ? ScriptRuntime.toString(args[0]) : DEFAULT_LABEL;
        AtomicInteger counter = this.counters.remove(label);
        if (counter == null) {
            this.print(cx, scope, Level.WARN, "Count for '" + label + "' does not exist.");
        }
    }

    private void time(Context cx, Scriptable scope, Object[] args) {
        String label = args.length > 0 ? ScriptRuntime.toString(args[0]) : DEFAULT_LABEL;
        Long start = this.timers.get(label);
        if (start != null) {
            this.print(cx, scope, Level.WARN, "Timer '" + label + "' already exists.");
            return;
        }
        this.timers.put(label, System.nanoTime());
    }

    private void timeEnd(Context cx, Scriptable scope, Object[] args) {
        String label = args.length > 0 ? ScriptRuntime.toString(args[0]) : DEFAULT_LABEL;
        Long start = this.timers.remove(label);
        if (start == null) {
            this.print(cx, scope, Level.WARN, "Timer '" + label + "' does not exist.");
            return;
        }
        this.print(cx, scope, Level.INFO, label + ": " + this.nano2Milli(System.nanoTime() - start) + "ms");
    }

    private void timeLog(Context cx, Scriptable scope, Object[] args) {
        String label = args.length > 0 ? ScriptRuntime.toString(args[0]) : DEFAULT_LABEL;
        Long start = this.timers.get(label);
        if (start == null) {
            this.print(cx, scope, Level.WARN, "Timer '" + label + "' does not exist.");
            return;
        }
        StringBuilder msg = new StringBuilder(label + ": " + this.nano2Milli(System.nanoTime() - start) + "ms");
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                msg.append(" ").append(ScriptRuntime.toString(args[i]));
            }
        }
        this.print(cx, scope, Level.INFO, msg.toString());
    }

    private double nano2Milli(Long nano) {
        return (double)nano.longValue() / 1000000.0;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "log" -> 4;
            case "info" -> 5;
            case "time" -> 11;
            case "warn" -> 6;
            case "count" -> 9;
            case "debug" -> 3;
            case "error" -> 7;
            case "trace" -> 2;
            case "assert" -> 8;
            case "timeEnd" -> 12;
            case "timeLog" -> 13;
            case "toSource" -> 1;
            case "countReset" -> 10;
            default -> 0;
        };
    }

    public static interface ConsolePrinter
    extends Serializable {
        public void print(Context var1, Scriptable var2, Level var3, Object[] var4, ScriptStackElement[] var5);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

