/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript;

import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Context;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.IdFunctionObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.IdScriptableObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.JavaScriptException;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.NativeFunction;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.NativeIterator;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.RhinoException;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptRuntime;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Scriptable;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptableObject;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Undefined;

public final class NativeGenerator
extends IdScriptableObject {
    private static final long serialVersionUID = 1645892441041347273L;
    private static final Object GENERATOR_TAG = "Generator";
    public static final int GENERATOR_SEND = 0;
    public static final int GENERATOR_THROW = 1;
    public static final int GENERATOR_CLOSE = 2;
    private static final int Id_close = 1;
    private static final int Id_next = 2;
    private static final int Id_send = 3;
    private static final int Id_throw = 4;
    private static final int Id___iterator__ = 5;
    private static final int MAX_PROTOTYPE_ID = 5;
    private NativeFunction function;
    private Object savedState;
    private String lineSource;
    private int lineNumber;
    private boolean firstTime = true;
    private boolean locked;

    static NativeGenerator init(ScriptableObject scope, boolean sealed) {
        NativeGenerator prototype = new NativeGenerator();
        if (scope != null) {
            prototype.setParentScope(scope);
            prototype.setPrototype(NativeGenerator.getObjectPrototype(scope));
        }
        prototype.activatePrototypeMap(5);
        if (sealed) {
            prototype.sealObject();
        }
        if (scope != null) {
            scope.associateValue(GENERATOR_TAG, prototype);
        }
        return prototype;
    }

    private NativeGenerator() {
    }

    public NativeGenerator(Scriptable scope, NativeFunction function, Object savedState) {
        this.function = function;
        this.savedState = savedState;
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        this.setParentScope(top);
        NativeGenerator prototype = (NativeGenerator)ScriptableObject.getTopScopeValue(top, GENERATOR_TAG);
        this.setPrototype(prototype);
    }

    @Override
    public String getClassName() {
        return "Generator";
    }

    @Override
    protected void initPrototypeId(int id) {
        int arity;
        this.initPrototypeMethod(GENERATOR_TAG, id, switch (id) {
            case 1 -> {
                arity = 1;
                yield "close";
            }
            case 2 -> {
                arity = 1;
                yield "next";
            }
            case 3 -> {
                arity = 0;
                yield "send";
            }
            case 4 -> {
                arity = 0;
                yield "throw";
            }
            case 5 -> {
                arity = 1;
                yield "__iterator__";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(GENERATOR_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        NativeGenerator generator = NativeGenerator.ensureType(thisObj, NativeGenerator.class, f);
        switch (id) {
            case 1: {
                return generator.resume(cx, scope, 2, new GeneratorClosedException());
            }
            case 2: {
                generator.firstTime = false;
                return generator.resume(cx, scope, 0, Undefined.instance);
            }
            case 3: {
                Object arg;
                Object object = arg = args.length > 0 ? args[0] : Undefined.instance;
                if (generator.firstTime && !arg.equals(Undefined.instance)) {
                    throw ScriptRuntime.typeErrorById("msg.send.newborn", new Object[0]);
                }
                return generator.resume(cx, scope, 0, arg);
            }
            case 4: {
                return generator.resume(cx, scope, 1, args.length > 0 ? args[0] : Undefined.instance);
            }
            case 5: {
                return thisObj;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resume(Context cx, Scriptable scope, int operation, Object value) {
        if (this.savedState == null) {
            if (operation == 2) {
                return Undefined.instance;
            }
            Object thrown = operation == 1 ? value : NativeIterator.getStopIterationObject(scope);
            throw new JavaScriptException(thrown, this.lineSource, this.lineNumber);
        }
        try {
            Object thrown = this;
            synchronized (thrown) {
                if (this.locked) {
                    throw ScriptRuntime.typeErrorById("msg.already.exec.gen", new Object[0]);
                }
                this.locked = true;
            }
            thrown = this.function.resumeGenerator(cx, scope, operation, this.savedState, value);
            return thrown;
        }
        catch (GeneratorClosedException e) {
            Object object = Undefined.instance;
            return object;
        }
        catch (RhinoException e) {
            this.lineNumber = e.lineNumber();
            this.lineSource = e.lineSource();
            this.savedState = null;
            throw e;
        }
        finally {
            NativeGenerator nativeGenerator = this;
            synchronized (nativeGenerator) {
                this.locked = false;
            }
            if (operation == 2) {
                this.savedState = null;
            }
        }
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "close" -> 1;
            case "next" -> 2;
            case "send" -> 3;
            case "throw" -> 4;
            case "__iterator__" -> 5;
            default -> 0;
        };
    }

    public static class GeneratorClosedException
    extends RuntimeException {
        private static final long serialVersionUID = 2561315658662379681L;
    }
}

