/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.regexp;

import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.BaseFunction;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Context;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ScriptRuntime;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Scriptable;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.TopLevel;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Undefined;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.regexp.NativeRegExp;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.regexp.NativeRegExpInstantiator;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.regexp.RegExpImpl;

class NativeRegExpCtor
extends BaseFunction {
    private static final long serialVersionUID = -5733330028285400526L;
    private static final int Id_multiline = 1;
    private static final int Id_STAR = 2;
    private static final int Id_input = 3;
    private static final int Id_UNDERSCORE = 4;
    private static final int Id_lastMatch = 5;
    private static final int Id_AMPERSAND = 6;
    private static final int Id_lastParen = 7;
    private static final int Id_PLUS = 8;
    private static final int Id_leftContext = 9;
    private static final int Id_BACK_QUOTE = 10;
    private static final int Id_rightContext = 11;
    private static final int Id_QUOTE = 12;
    private static final int DOLLAR_ID_BASE = 12;
    private static final int Id_DOLLAR_1 = 13;
    private static final int Id_DOLLAR_2 = 14;
    private static final int Id_DOLLAR_3 = 15;
    private static final int Id_DOLLAR_4 = 16;
    private static final int Id_DOLLAR_5 = 17;
    private static final int Id_DOLLAR_6 = 18;
    private static final int Id_DOLLAR_7 = 19;
    private static final int Id_DOLLAR_8 = 20;
    private static final int Id_DOLLAR_9 = 21;
    private static final int MAX_INSTANCE_ID = 21;
    private int multilineAttr = 4;
    private int starAttr = 4;
    private int inputAttr = 4;
    private int underscoreAttr = 4;

    NativeRegExpCtor() {
    }

    @Override
    public String getFunctionName() {
        return "RegExp";
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length > 0 && args[0] instanceof NativeRegExp && (args.length == 1 || args[1] == Undefined.instance)) {
            return args[0];
        }
        return this.construct(cx, scope, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        NativeRegExp re = NativeRegExpInstantiator.withLanguageVersion(cx.getLanguageVersion());
        re.compile(cx, scope, args);
        ScriptRuntime.setBuiltinProtoAndParent(re, scope, TopLevel.Builtins.RegExp);
        return re;
    }

    private static RegExpImpl getImpl() {
        Context cx = Context.getCurrentContext();
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(cx);
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 21;
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int id = switch (s) {
            case "multiline" -> 1;
            case "$*" -> 2;
            case "input" -> 3;
            case "$_" -> 4;
            case "lastMatch" -> 5;
            case "$&" -> 6;
            case "lastParen" -> 7;
            case "$+" -> 8;
            case "leftContext" -> 9;
            case "$`" -> 10;
            case "rightContext" -> 11;
            case "$'" -> 12;
            case "$1" -> 13;
            case "$2" -> 14;
            case "$3" -> 15;
            case "$4" -> 16;
            case "$5" -> 17;
            case "$6" -> 18;
            case "$7" -> 19;
            case "$8" -> 20;
            case "$9" -> 21;
            default -> 0;
        };
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        return NativeRegExpCtor.instanceIdInfo(switch (id) {
            case 1 -> this.multilineAttr;
            case 2 -> this.starAttr;
            case 3 -> this.inputAttr;
            case 4 -> this.underscoreAttr;
            default -> 5;
        }, super.getMaxInstanceId() + id);
    }

    @Override
    protected String getInstanceIdName(int id) {
        int shifted = id - super.getMaxInstanceId();
        if (1 <= shifted && shifted <= 21) {
            switch (shifted) {
                case 1: {
                    return "multiline";
                }
                case 2: {
                    return "$*";
                }
                case 3: {
                    return "input";
                }
                case 4: {
                    return "$_";
                }
                case 5: {
                    return "lastMatch";
                }
                case 6: {
                    return "$&";
                }
                case 7: {
                    return "lastParen";
                }
                case 8: {
                    return "$+";
                }
                case 9: {
                    return "leftContext";
                }
                case 10: {
                    return "$`";
                }
                case 11: {
                    return "rightContext";
                }
                case 12: {
                    return "$'";
                }
            }
            int substring_number = shifted - 12 - 1;
            char[] buf = new char[]{'$', (char)(49 + substring_number)};
            return new String(buf);
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        int shifted = id - super.getMaxInstanceId();
        if (1 <= shifted && shifted <= 21) {
            Object stringResult;
            RegExpImpl impl = NativeRegExpCtor.getImpl();
            switch (shifted) {
                case 1: 
                case 2: {
                    return ScriptRuntime.wrapBoolean(impl.multiline);
                }
                case 3: 
                case 4: {
                    stringResult = impl.input;
                    break;
                }
                case 5: 
                case 6: {
                    stringResult = impl.lastMatch;
                    break;
                }
                case 7: 
                case 8: {
                    stringResult = impl.lastParen;
                    break;
                }
                case 9: 
                case 10: {
                    stringResult = impl.leftContext;
                    break;
                }
                case 11: 
                case 12: {
                    stringResult = impl.rightContext;
                    break;
                }
                default: {
                    int substring_number = shifted - 12 - 1;
                    stringResult = impl.getParenSubString(substring_number);
                    break;
                }
            }
            return stringResult == null ? "" : stringResult.toString();
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected void setInstanceIdValue(int id, Object value) {
        int shifted = id - super.getMaxInstanceId();
        switch (shifted) {
            case 1: 
            case 2: {
                NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(value);
                return;
            }
            case 3: 
            case 4: {
                NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(value);
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        int substring_number = shifted - 12 - 1;
        if (0 <= substring_number && substring_number <= 8) {
            return;
        }
        super.setInstanceIdValue(id, value);
    }

    @Override
    protected void setInstanceIdAttributes(int id, int attr) {
        int shifted = id - super.getMaxInstanceId();
        switch (shifted) {
            case 1: {
                this.multilineAttr = attr;
                return;
            }
            case 2: {
                this.starAttr = attr;
                return;
            }
            case 3: {
                this.inputAttr = attr;
                return;
            }
            case 4: {
                this.underscoreAttr = attr;
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        int substring_number = shifted - 12 - 1;
        if (0 <= substring_number && substring_number <= 8) {
            return;
        }
        super.setInstanceIdAttributes(id, attr);
    }
}

