/*
 * Decompiled with CFR 0.152.
 */
package vendor.cn.zbx1425.sowcerext.de.javagl.obj;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import vendor.cn.zbx1425.sowcerext.de.javagl.obj.FloatTuple;
import vendor.cn.zbx1425.sowcerext.de.javagl.obj.ObjFace;
import vendor.cn.zbx1425.sowcerext.de.javagl.obj.ReadableObj;

public class ObjData {
    private static int[] getNumFaceVertices(ReadableObj obj) {
        int[] numVerticesOfFaces = new int[obj.getNumFaces()];
        for (int i = 0; i < obj.getNumFaces(); ++i) {
            ObjFace face = obj.getFace(i);
            numVerticesOfFaces[i] = face.getNumVertices();
        }
        return numVerticesOfFaces;
    }

    public static int getTotalNumFaceVertices(ReadableObj obj) {
        return ObjData.sum(ObjData.getNumFaceVertices(obj));
    }

    private static int sum(int[] array) {
        int sum = 0;
        for (int i : array) {
            sum += i;
        }
        return sum;
    }

    public static int[] getFaceVertexIndicesArray(ReadableObj obj) {
        int[] array = new int[ObjData.getTotalNumFaceVertices(obj)];
        ObjData.getFaceVertexIndices(obj, IntBuffer.wrap(array));
        return array;
    }

    public static IntBuffer getFaceVertexIndices(ReadableObj obj) {
        IntBuffer buffer = ObjData.createDirectIntBuffer(ObjData.getTotalNumFaceVertices(obj));
        ObjData.getFaceVertexIndices(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static int[] getFaceVertexIndicesArray(ReadableObj obj, int numVerticesPerFace) {
        int[] array = new int[obj.getNumFaces() * numVerticesPerFace];
        ObjData.getFaceVertexIndices(obj, IntBuffer.wrap(array));
        return array;
    }

    public static IntBuffer getFaceVertexIndices(ReadableObj obj, int numVerticesPerFace) {
        IntBuffer buffer = ObjData.createDirectIntBuffer(obj.getNumFaces() * numVerticesPerFace);
        ObjData.getFaceVertexIndices(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static void getFaceVertexIndices(ReadableObj obj, IntBuffer target) {
        for (int i = 0; i < obj.getNumFaces(); ++i) {
            ObjFace face = obj.getFace(i);
            for (int j = 0; j < face.getNumVertices(); ++j) {
                target.put(face.getVertexIndex(j));
            }
        }
    }

    public static int[] getFaceTexCoordIndicesArray(ReadableObj obj) {
        int[] array = new int[ObjData.getTotalNumFaceVertices(obj)];
        ObjData.getFaceTexCoordIndices(obj, IntBuffer.wrap(array));
        return array;
    }

    public static IntBuffer getFaceTexCoordIndices(ReadableObj obj) {
        IntBuffer buffer = ObjData.createDirectIntBuffer(ObjData.getTotalNumFaceVertices(obj));
        ObjData.getFaceTexCoordIndices(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static int[] getFaceTexCoordIndicesArray(ReadableObj obj, int numVerticesPerFace) {
        int[] array = new int[obj.getNumFaces() * numVerticesPerFace];
        ObjData.getFaceTexCoordIndices(obj, IntBuffer.wrap(array));
        return array;
    }

    public static IntBuffer getFaceTexCoordIndices(ReadableObj obj, int numVerticesPerFace) {
        IntBuffer buffer = ObjData.createDirectIntBuffer(obj.getNumFaces() * numVerticesPerFace);
        ObjData.getFaceTexCoordIndices(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static void getFaceTexCoordIndices(ReadableObj obj, IntBuffer target) {
        for (int i = 0; i < obj.getNumFaces(); ++i) {
            ObjFace face = obj.getFace(i);
            for (int j = 0; j < face.getNumVertices(); ++j) {
                target.put(face.getTexCoordIndex(j));
            }
        }
    }

    public static int[] getFaceNormalIndicesArray(ReadableObj obj) {
        int[] array = new int[ObjData.getTotalNumFaceVertices(obj)];
        ObjData.getFaceNormalIndices(obj, IntBuffer.wrap(array));
        return array;
    }

    public static IntBuffer getFaceNormalIndices(ReadableObj obj) {
        IntBuffer buffer = ObjData.createDirectIntBuffer(ObjData.getTotalNumFaceVertices(obj));
        ObjData.getFaceNormalIndices(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static int[] getFaceNormalIndicesArray(ReadableObj obj, int numVerticesPerFace) {
        int[] array = new int[obj.getNumFaces() * numVerticesPerFace];
        ObjData.getFaceNormalIndices(obj, IntBuffer.wrap(array));
        return array;
    }

    public static IntBuffer getFaceNormalIndices(ReadableObj obj, int numVerticesPerFace) {
        IntBuffer buffer = ObjData.createDirectIntBuffer(obj.getNumFaces() * numVerticesPerFace);
        ObjData.getFaceNormalIndices(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static void getFaceNormalIndices(ReadableObj obj, IntBuffer target) {
        for (int i = 0; i < obj.getNumFaces(); ++i) {
            ObjFace face = obj.getFace(i);
            for (int j = 0; j < face.getNumVertices(); ++j) {
                target.put(face.getNormalIndex(j));
            }
        }
    }

    public static float[] getVerticesArray(ReadableObj obj) {
        float[] array = new float[obj.getNumVertices() * 3];
        ObjData.getVertices(obj, FloatBuffer.wrap(array));
        return array;
    }

    public static FloatBuffer getVertices(ReadableObj obj) {
        FloatBuffer buffer = ObjData.createDirectFloatBuffer(obj.getNumVertices() * 3);
        ObjData.getVertices(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static void getVertices(ReadableObj obj, FloatBuffer target) {
        for (int i = 0; i < obj.getNumVertices(); ++i) {
            FloatTuple tuple = obj.getVertex(i);
            target.put(tuple.getX());
            target.put(tuple.getY());
            target.put(tuple.getZ());
        }
    }

    public static float[] getTexCoordsArray(ReadableObj obj, int dimensions) {
        return ObjData.getTexCoordsArray(obj, dimensions, false);
    }

    public static float[] getTexCoordsArray(ReadableObj obj, int dimensions, boolean flipY) {
        float[] array = new float[obj.getNumTexCoords() * dimensions];
        ObjData.getTexCoords(obj, FloatBuffer.wrap(array), dimensions, flipY);
        return array;
    }

    public static FloatBuffer getTexCoords(ReadableObj obj, int dimensions) {
        return ObjData.getTexCoords(obj, dimensions, false);
    }

    public static FloatBuffer getTexCoords(ReadableObj obj, int dimensions, boolean flipY) {
        FloatBuffer buffer = ObjData.createDirectFloatBuffer(obj.getNumTexCoords() * dimensions);
        ObjData.getTexCoords(obj, buffer, dimensions, flipY);
        buffer.position(0);
        return buffer;
    }

    public static void getTexCoords(ReadableObj obj, FloatBuffer target, int dimensions) {
        ObjData.getTexCoords(obj, target, dimensions, false);
    }

    public static void getTexCoords(ReadableObj obj, FloatBuffer target, int dimensions, boolean flipY) {
        if (flipY) {
            for (int i = 0; i < obj.getNumTexCoords(); ++i) {
                FloatTuple tuple = obj.getTexCoord(i);
                for (int j = 0; j < dimensions; ++j) {
                    if (j == 1) {
                        target.put(1.0f - tuple.get(j));
                        continue;
                    }
                    target.put(tuple.get(j));
                }
            }
        } else {
            for (int i = 0; i < obj.getNumTexCoords(); ++i) {
                FloatTuple tuple = obj.getTexCoord(i);
                for (int j = 0; j < dimensions; ++j) {
                    target.put(tuple.get(j));
                }
            }
        }
    }

    public static float[] getNormalsArray(ReadableObj obj) {
        float[] array = new float[obj.getNumNormals() * 3];
        ObjData.getNormals(obj, FloatBuffer.wrap(array));
        return array;
    }

    public static FloatBuffer getNormals(ReadableObj obj) {
        FloatBuffer buffer = ObjData.createDirectFloatBuffer(obj.getNumNormals() * 3);
        ObjData.getNormals(obj, buffer);
        buffer.position(0);
        return buffer;
    }

    public static void getNormals(ReadableObj obj, FloatBuffer target) {
        for (int i = 0; i < obj.getNumNormals(); ++i) {
            FloatTuple tuple = obj.getNormal(i);
            target.put(tuple.getX());
            target.put(tuple.getY());
            target.put(tuple.getZ());
        }
    }

    public static ShortBuffer convertToShortBuffer(IntBuffer intBuffer) {
        ShortBuffer shortBuffer = ObjData.createDirectShortBuffer(intBuffer.capacity());
        for (int i = 0; i < intBuffer.capacity(); ++i) {
            shortBuffer.put(i, (short)intBuffer.get());
        }
        return shortBuffer;
    }

    private static IntBuffer createDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    private static ShortBuffer createDirectShortBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    private static FloatBuffer createDirectFloatBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    private ObjData() {
    }
}

