/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mtr.block.IBlock;
import mtr.data.IPIDSRenderChild;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class BlockArrivalProjectorBase
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public BlockArrivalProjectorBase() {
        super(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15978).method_29292().method_9632(2.0f).method_9631(state -> 5).method_22488());
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof TileEntityArrivalProjectorBase) {
                ((TileEntityArrivalProjectorBase)entity).syncData();
                PacketTrainDataGuiServer.openArrivalProjectorConfigScreenS2C((class_3222)player, pos);
            }
        });
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 side = ctx.method_8038();
        if (side != class_2350.field_11036 && side != class_2350.field_11033) {
            return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)side.method_10153());
        }
        return null;
    }

    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 collisionContext) {
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, field_11177);
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, 1.0, facing);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    public static class TileEntityArrivalProjectorBase
    extends BlockEntityClientSerializableMapper
    implements IPIDSRenderChild {
        private final Set<Long> platformIds = new HashSet<Long>();
        private int displayPage;
        private static final String KEY_PLATFORM_IDS = "platform_ids";
        private static final String KEY_DISPLAY_PAGE = "display_page";

        public TileEntityArrivalProjectorBase(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            long[] platformIdsArray;
            this.platformIds.clear();
            for (long platformId : platformIdsArray = compoundTag.method_10565(KEY_PLATFORM_IDS)) {
                this.platformIds.add(platformId);
            }
            this.displayPage = compoundTag.method_10550(KEY_DISPLAY_PAGE);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10538(KEY_PLATFORM_IDS, new ArrayList<Long>(this.platformIds));
            compoundTag.method_10569(KEY_DISPLAY_PAGE, this.displayPage);
        }

        public Set<Long> getPlatformIds() {
            return this.platformIds;
        }

        @Override
        public int getDisplayPage() {
            return this.displayPage;
        }

        public void setData(Set<Long> platformIds, int displayPage) {
            this.platformIds.clear();
            this.platformIds.addAll(platformIds);
            this.displayPage = displayPage;
            this.method_5431();
            this.syncData();
        }
    }
}

