/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.Items;
import mtr.block.IBlock;
import mtr.mappings.HorizontalBlockWithSoftLanding;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_3542;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public abstract class BlockEscalatorBase
extends HorizontalBlockWithSoftLanding
implements IBlock {
    public static final class_2754<EnumEscalatorOrientation> ORIENTATION = class_2754.method_11850((String)"orientation", EnumEscalatorOrientation.class);

    protected BlockEscalatorBase() {
        super(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15978).method_29292().method_9632(2.0f).method_22488());
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (this.getSideDirection(state) == direction && !newState.method_27852((class_2248)this)) {
            return class_2246.field_10124.method_9564();
        }
        return (class_2680)state.method_11657(ORIENTATION, (Comparable)((Object)this.getOrientation((class_1922)world, pos, state)));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 collisionContext) {
        EnumEscalatorOrientation orientation = this.getOrientation(world, pos, state);
        if (orientation == EnumEscalatorOrientation.SLOPE || orientation == EnumEscalatorOrientation.TRANSITION_TOP) {
            return class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (class_265)IBlock.getVoxelShapeByDirection(0.0, 8.0, 0.0, 16.0, 15.0, 8.0, (class_2350)IBlock.getStatePropertySafe(state, field_11177)));
        }
        return class_259.method_1077();
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state;
    }

    public class_1792 method_8389() {
        return Items.ESCALATOR.get();
    }

    public class_1799 method_9574(class_1922 blockGetter, class_2338 blockPos, class_2680 blockState) {
        return new class_1799((class_1935)this.method_8389());
    }

    public class_3619 method_9527(class_2680 blockState) {
        return class_3619.field_15972;
    }

    protected final EnumEscalatorOrientation getOrientation(class_1922 world, class_2338 pos, class_2680 state) {
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, field_11177);
        class_2338 posAhead = pos.method_10093(facing);
        class_2338 posBehind = pos.method_10079(facing, -1);
        boolean isAhead = state.method_27852(world.method_8320(posAhead).method_26204());
        boolean isAheadUp = state.method_27852(world.method_8320(posAhead.method_10084()).method_26204());
        boolean isBehind = state.method_27852(world.method_8320(posBehind).method_26204());
        boolean isBehindDown = state.method_27852(world.method_8320(posBehind.method_10074()).method_26204());
        if (isAhead && isBehind) {
            return EnumEscalatorOrientation.FLAT;
        }
        if (isAheadUp && isBehindDown) {
            return EnumEscalatorOrientation.SLOPE;
        }
        if (isAheadUp && isBehind) {
            return EnumEscalatorOrientation.TRANSITION_BOTTOM;
        }
        if (isAhead && isBehindDown) {
            return EnumEscalatorOrientation.TRANSITION_TOP;
        }
        if (isBehind) {
            return EnumEscalatorOrientation.LANDING_TOP;
        }
        return EnumEscalatorOrientation.LANDING_BOTTOM;
    }

    @Override
    private class_2350 getSideDirection(class_2680 state) {
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, field_11177);
        return IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT ? facing.method_10160() : facing.method_10170();
    }

    protected static enum EnumEscalatorOrientation implements class_3542
    {
        LANDING_BOTTOM("landing_bottom"),
        LANDING_TOP("landing_top"),
        FLAT("flat"),
        SLOPE("slope"),
        TRANSITION_BOTTOM("transition_bottom"),
        TRANSITION_TOP("transition_top");

        private final String name;

        private EnumEscalatorOrientation(String nameIn) {
            this.name = nameIn;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

