/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import mtr.BlockEntityTypes;
import mtr.Items;
import mtr.MTR;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.data.LiftInstructions;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.mappings.TickableMapper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class BlockLiftButtons
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public static final class_2746 UNLOCKED = class_2746.method_11825((String)"unlocked");

    public BlockLiftButtons() {
        super(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15978).method_29292().method_9632(2.0f));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 hit) {
        class_1269 result = IBlock.checkHoldingBrush(world, player, () -> {
            boolean unlocked = (Boolean)IBlock.getStatePropertySafe(state, UNLOCKED) == false;
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)UNLOCKED, (Comparable)Boolean.valueOf(unlocked)));
            player.method_7353((class_2561)(unlocked ? Text.translatable("gui.mtr.lift_buttons_unlocked", new Object[0]) : Text.translatable("gui.mtr.lift_buttons_locked", new Object[0])), true);
        });
        if (world.field_9236 || result == class_1269.field_5812) {
            return class_1269.field_5812;
        }
        if (player.method_24518(Items.LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.method_24518(Items.LIFT_BUTTONS_LINK_REMOVER.get())) {
            return class_1269.field_5811;
        }
        boolean unlocked = (Boolean)IBlock.getStatePropertySafe(state, UNLOCKED);
        if (unlocked) {
            double y = hit.method_17784().field_1351;
            LiftInstructions.addInstruction(world, pos, y - Math.floor(y) > 0.25);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8042();
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)facing);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 collisionContext) {
        return IBlock.getVoxelShapeByDirection(4.0, 0.0, 0.0, 12.0, 16.0, 1.0, (class_2350)IBlock.getStatePropertySafe(state, field_11177));
    }

    @Override
    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntityLiftButtons(pos, state);
    }

    @Override
    public <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
        TileEntityLiftButtons.tick(world, pos, blockEntity);
    }

    @Override
    public class_2591<? extends BlockEntityMapper> getType() {
        return BlockEntityTypes.LIFT_BUTTONS_1_TILE_ENTITY.get();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, UNLOCKED});
    }

    public static class TileEntityLiftButtons
    extends BlockEntityClientSerializableMapper
    implements TickableMapper {
        private final Set<class_2338> trackPositions = new HashSet<class_2338>();
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";
        private static final int UPDATE_INTERVAL = 60;

        public TileEntityLiftButtons(class_2338 pos, class_2680 state) {
            super(BlockEntityTypes.LIFT_BUTTONS_1_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            this.trackPositions.clear();
            for (long position : compoundTag.method_10565(KEY_TRACK_FLOOR_POS)) {
                this.trackPositions.add(class_2338.method_10092((long)position));
            }
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            ArrayList trackPositionsList = new ArrayList();
            this.trackPositions.forEach(position -> trackPositionsList.add(position.method_10063()));
            compoundTag.method_10538(KEY_TRACK_FLOOR_POS, trackPositionsList);
        }

        @Override
        public void tick() {
            TileEntityLiftButtons.tick(this.field_11863, this.field_11867, this);
        }

        public void registerFloor(class_2338 pos, boolean isAdd) {
            if (isAdd) {
                this.trackPositions.add(pos);
            } else {
                this.trackPositions.remove(pos);
            }
            this.method_5431();
            this.syncData();
        }

        public void forEachTrackPosition(class_1937 world, BiConsumer<class_2338, BlockLiftTrackFloor.TileEntityLiftTrackFloor> callback) {
            HashSet trackPositionsToRemove = new HashSet();
            this.trackPositions.forEach(trackPosition -> {
                class_2586 blockEntity = world.method_8321(trackPosition);
                if (blockEntity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
                    if (callback != null) {
                        callback.accept((class_2338)trackPosition, (BlockLiftTrackFloor.TileEntityLiftTrackFloor)blockEntity);
                    }
                } else {
                    trackPositionsToRemove.add(trackPosition);
                }
            });
            trackPositionsToRemove.forEach(this.trackPositions::remove);
        }

        public static <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
            if (world != null && world.method_8604((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 16.0, entity -> true) != null && blockEntity instanceof TileEntityLiftButtons && !world.field_9236 && MTR.isGameTickInterval(60, (int)pos.method_10063())) {
                ((TileEntityLiftButtons)blockEntity).forEachTrackPosition(world, null);
                blockEntity.method_5431();
                ((TileEntityLiftButtons)blockEntity).syncData();
            }
        }
    }
}

