/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.List;
import mtr.Items;
import mtr.MTR;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.block.ITripleBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.mappings.TickableMapper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class BlockLiftPanelBase
extends BlockDirectionalMapper
implements EntityBlockMapper,
ITripleBlock {
    private final boolean isOdd;
    private final boolean isFlat;
    @Deprecated
    public static final class_2746 LEFT = class_2746.method_11825((String)"left");
    @Deprecated
    public static final class_2746 TEMP = class_2746.method_11825((String)"temp");

    public BlockLiftPanelBase(boolean isOdd, boolean isFlat) {
        super(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15978).method_29292().method_9632(2.0f).method_9631(state -> 5));
        this.isOdd = isOdd;
        this.isFlat = isFlat;
    }

    public class_2689<class_2248, class_2680> method_9595() {
        return super.method_9595();
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (this.isOdd) {
            return ITripleBlock.updateShape(state, direction, newState.method_27852((class_2248)this), () -> super.method_9559(state, direction, newState, world, pos, posFrom));
        }
        if (IBlock.getSideDirection(state) == direction && !newState.method_27852((class_2248)this)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042();
        if (this.isOdd) {
            return IBlock.isReplaceable(ctx, direction.method_10170(), 3) ? (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction)).method_11657((class_2769)SIDE, (Comparable)((Object)IBlock.EnumSide.LEFT))).method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(false)) : null;
        }
        if (this.isFlat) {
            return IBlock.isReplaceable(ctx, direction.method_10170(), 2) ? (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction)).method_11657((class_2769)SIDE, (Comparable)((Object)IBlock.EnumSide.LEFT)) : null;
        }
        return IBlock.isReplaceable(ctx, direction.method_10170(), 2) ? (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction)).method_11657((class_2769)SIDE, (Comparable)((Object)IBlock.EnumSide.LEFT))).method_11657((class_2769)TEMP, (Comparable)Boolean.valueOf(false)) : null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, this.isFlat ? 1.0 : 4.0, (class_2350)state.method_11654((class_2769)field_11177));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        if (!world.field_9236) {
            class_2350 direction = (class_2350)IBlock.getStatePropertySafe(state, field_11177);
            if (this.isOdd) {
                world.method_8652(pos.method_10093(direction.method_10170()), (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction)).method_11657((class_2769)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT))).method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(true)), 3);
                world.method_8652(pos.method_10079(direction.method_10170(), 2), (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction)).method_11657((class_2769)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT))).method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(false)), 3);
                world.method_8452(pos.method_10093(direction.method_10170()), class_2246.field_10124);
                state.method_30101((class_1936)world, pos.method_10093(direction.method_10170()), 3);
            } else if (this.isFlat) {
                world.method_8652(pos.method_10093(direction.method_10170()), (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction)).method_11657((class_2769)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT)), 3);
            } else {
                world.method_8652(pos.method_10093(direction.method_10170()), (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction)).method_11657((class_2769)SIDE, (Comparable)((Object)IBlock.EnumSide.RIGHT))).method_11657((class_2769)TEMP, (Comparable)Boolean.valueOf(false)), 3);
            }
            world.method_8452(pos, class_2246.field_10124);
            state.method_30101((class_1936)world, pos, 3);
        }
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (this.isOdd) {
            ITripleBlock.playerWillDestroy(world, pos, state, player, false);
        } else if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            IBlock.onBreakCreative(world, player, pos.method_10093(IBlock.getSideDirection(state)));
        }
        super.method_9576(world, pos, state, player);
    }

    public class_3619 method_9527(class_2680 blockState) {
        return class_3619.field_15972;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        return player.method_24518(Items.LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.method_24518(Items.LIFT_BUTTONS_LINK_REMOVER.get()) ? class_1269.field_5811 : class_1269.field_5814;
    }

    @Override
    public <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
        TileEntityLiftPanel1Base.tick(world, pos, blockEntity);
    }

    public void method_9568(class_1799 itemStack, class_1922 blockGetter, List<class_2561> tooltip, class_1836 tooltipFlag) {
        tooltip.add((class_2561)Text.translatable("tooltip.mtr.railway_sign_" + (this.isOdd ? "odd" : "even"), new Object[0]).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
    }

    public static abstract class TileEntityLiftPanel1Base
    extends BlockEntityClientSerializableMapper
    implements TickableMapper {
        private class_2338 trackPosition = null;
        protected boolean converted = false;
        private final boolean isOdd;
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";
        private static final String KEY_CONVERTED = "converted";
        private static final int UPDATE_INTERVAL = 60;

        public TileEntityLiftPanel1Base(class_2591<?> type, class_2338 pos, class_2680 state, boolean isOdd) {
            super(type, pos, state);
            this.isOdd = isOdd;
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            long data = compoundTag.method_10537(KEY_TRACK_FLOOR_POS);
            this.trackPosition = data == 0L ? null : class_2338.method_10092((long)data);
            this.converted = compoundTag.method_10577(KEY_CONVERTED);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10544(KEY_TRACK_FLOOR_POS, this.trackPosition == null ? 0L : this.trackPosition.method_10063());
            compoundTag.method_10556(KEY_CONVERTED, this.converted);
        }

        @Override
        public void tick() {
            TileEntityLiftPanel1Base.tick(this.field_11863, this.field_11867, this);
        }

        public void registerFloor(class_2338 pos, boolean isAdd) {
            if (this.field_11863 == null) {
                return;
            }
            this.setFloor((class_2338)(isAdd ? pos : null));
            class_2680 state = this.field_11863.method_8320(this.method_11016());
            class_2586 blockEntity = this.field_11863.method_8321(this.isOdd && (Boolean)IBlock.getStatePropertySafe(state, ITripleBlock.ODD) != false ? this.method_11016() : this.method_11016().method_10093(IBlock.getSideDirection(state)));
            if (blockEntity instanceof TileEntityLiftPanel1Base) {
                ((TileEntityLiftPanel1Base)blockEntity).setFloor((class_2338)(isAdd ? pos : null));
            }
        }

        public class_2338 getTrackPosition(class_1937 world) {
            if (this.trackPosition != null && !(world.method_8321(this.trackPosition) instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor)) {
                this.trackPosition = null;
            }
            return this.trackPosition;
        }

        private void setFloor(class_2338 pos) {
            this.trackPosition = pos;
            this.method_5431();
            this.syncData();
        }

        protected void convert() {
            if (!this.converted) {
                this.converted = true;
                this.method_5431();
                this.syncData();
            }
        }

        public static <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
            if (world != null && world.method_8604((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 16.0, entity -> true) != null && blockEntity instanceof TileEntityLiftPanel1Base && !world.field_9236 && MTR.isGameTickInterval(60, (int)pos.method_10063())) {
                ((TileEntityLiftPanel1Base)blockEntity).getTrackPosition(world);
                blockEntity.method_5431();
                ((TileEntityLiftPanel1Base)blockEntity).syncData();
            }
            if (world != null && !world.field_9236 && blockEntity instanceof TileEntityLiftPanel1Base) {
                ((TileEntityLiftPanel1Base)blockEntity).convert();
            }
        }
    }
}

