/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.BlockEntityTypes;
import mtr.block.BlockLiftTrack;
import mtr.block.IBlock;
import mtr.data.RailwayData;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class BlockLiftTrackFloor
extends BlockLiftTrack
implements EntityBlockMapper {
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof TileEntityLiftTrackFloor) {
                ((TileEntityLiftTrackFloor)entity).syncData();
                PacketTrainDataGuiServer.openLiftTrackFloorScreenS2C((class_3222)player, pos);
            }
        });
    }

    @Override
    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntityLiftTrackFloor(pos, state);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        RailwayData railwayData;
        if (!world.field_9236 && (railwayData = RailwayData.getInstance(world)) != null) {
            railwayData.removeLiftFloorTrack(pos);
            PacketTrainDataGuiServer.removeLiftFloorTrackS2C(world, pos);
        }
    }

    public static class TileEntityLiftTrackFloor
    extends BlockEntityClientSerializableMapper {
        private String floorNumber = "1";
        private String floorDescription = "";
        private boolean shouldDing;
        private static final String KEY_FLOOR_NUMBER = "floor_number";
        private static final String KEY_FLOOR_DESCRIPTION = "floor_description";
        private static final String KEY_SHOULD_DING = "should_ding";

        public TileEntityLiftTrackFloor(class_2338 pos, class_2680 state) {
            super(BlockEntityTypes.LIFT_TRACK_FLOOR_1_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            this.floorNumber = compoundTag.method_10558(KEY_FLOOR_NUMBER);
            this.floorDescription = compoundTag.method_10558(KEY_FLOOR_DESCRIPTION);
            this.shouldDing = compoundTag.method_10577(KEY_SHOULD_DING);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10582(KEY_FLOOR_NUMBER, this.floorNumber);
            compoundTag.method_10582(KEY_FLOOR_DESCRIPTION, this.floorDescription);
            compoundTag.method_10556(KEY_SHOULD_DING, this.shouldDing);
        }

        public void setData(String floorNumber, String floorDescription, boolean shouldDing) {
            this.floorNumber = floorNumber;
            this.floorDescription = floorDescription;
            this.shouldDing = shouldDing;
            this.method_5431();
            this.syncData();
        }

        public String getFloorNumber() {
            return this.floorNumber;
        }

        public String getFloorDescription() {
            return this.floorDescription;
        }

        public boolean getShouldDing() {
            return this.shouldDing;
        }
    }
}

