/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.List;
import mtr.BlockEntityTypes;
import mtr.block.IBlock;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class BlockNode
extends BlockDirectionalMapper {
    public final TransportMode transportMode;
    public static final class_2746 FACING = class_2746.method_11825((String)"facing");
    public static final class_2746 IS_22_5 = class_2746.method_11825((String)"is_22_5");
    public static final class_2746 IS_45 = class_2746.method_11825((String)"is_45");
    public static final class_2746 IS_CONNECTED = class_2746.method_11825((String)"is_connected");

    public BlockNode(TransportMode transportMode) {
        super(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15978).method_9632(2.0f).method_22488());
        this.transportMode = transportMode;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IS_22_5, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IS_45, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        int quadrant = RailAngle.getQuadrant(ctx.method_8044(), true);
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)Boolean.valueOf(quadrant % 8 >= 4))).method_11657((class_2769)IS_45, (Comparable)Boolean.valueOf(quadrant % 4 >= 2))).method_11657((class_2769)IS_22_5, (Comparable)Boolean.valueOf(quadrant % 2 >= 1))).method_11657((class_2769)IS_CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        RailwayData railwayData;
        if (!world.field_9236 && (railwayData = RailwayData.getInstance(world)) != null) {
            railwayData.removeNode(player, pos, this.transportMode);
            PacketTrainDataGuiServer.removeNodeS2C(world, pos);
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 collisionContext) {
        return (Boolean)IBlock.getStatePropertySafe(state, IS_CONNECTED) != false ? class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0) : class_259.method_1077();
    }

    public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return class_259.method_1073();
    }

    public class_3619 method_9527(class_2680 blockState) {
        return class_3619.field_15972;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, IS_22_5, IS_45, IS_CONNECTED});
    }

    public static void resetRailNode(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof BlockNode) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)IS_CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static float getAngle(class_2680 state) {
        return (float)((Boolean)IBlock.getStatePropertySafe(state, FACING) != false ? 0 : 90) + ((Boolean)IBlock.getStatePropertySafe(state, IS_22_5) != false ? 22.5f : 0.0f) + (float)((Boolean)IBlock.getStatePropertySafe(state, IS_45) != false ? 45 : 0);
    }

    public static class BlockContinuousMovementNode
    extends BlockNode {
        public final boolean upper;
        public final boolean isStation;

        public BlockContinuousMovementNode(boolean upper, boolean isStation) {
            super(TransportMode.CABLE_CAR);
            this.upper = upper;
            this.isStation = isStation;
        }

        @Override
        public class_2680 method_9605(class_1750 ctx) {
            int quadrant = RailAngle.getQuadrant(ctx.method_8044(), false);
            return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)Boolean.valueOf(quadrant % 4 >= 2))).method_11657((class_2769)IS_45, (Comparable)Boolean.valueOf(quadrant % 2 >= 1))).method_11657((class_2769)IS_22_5, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)IS_CONNECTED, (Comparable)Boolean.valueOf(false));
        }

        @Override
        public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 collisionContext) {
            return class_2248.method_9541((double)0.0, (double)(this.upper ? 8.0 : 0.0), (double)0.0, (double)16.0, (double)(this.upper ? 16.0 : 8.0), (double)16.0);
        }

        public void method_9568(class_1799 itemStack, class_1922 blockGetter, List<class_2561> tooltip, class_1836 tooltipFlag) {
            String[] strings;
            for (String string : strings = Text.translatable("tooltip.mtr.cable_car_node" + (this.isStation ? "_station" : ""), new Object[0]).getString().split("\n")) {
                tooltip.add((class_2561)Text.literal(string).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
            }
        }
    }

    public static class TileEntityBoatNode
    extends BlockEntityMapper {
        public TileEntityBoatNode(class_2338 pos, class_2680 state) {
            super(BlockEntityTypes.BOAT_NODE_TILE_ENTITY.get(), pos, state);
        }
    }

    public static class BlockBoatNode
    extends BlockNode
    implements EntityBlockMapper {
        public BlockBoatNode() {
            super(TransportMode.BOAT);
        }

        public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
            if (state.method_26184((class_4538)world, pos)) {
                return state;
            }
            return class_2246.field_10124.method_9564();
        }

        public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            class_2338 posBelow = pos.method_10074();
            return (world.method_8316(posBelow).method_15772() != class_3612.field_15906 || world.method_8320(posBelow).method_26207() == class_3614.field_15958) && world.method_8316(pos).method_15772() == class_3612.field_15906;
        }

        @Override
        public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
            return new TileEntityBoatNode(pos, state);
        }
    }
}

