/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDAPGGlassEndBase;
import mtr.block.IBlock;
import mtr.data.IGui;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public abstract class BlockPSDAPGDoorBase
extends BlockPSDAPGBase
implements EntityBlockMapper {
    public static final int MAX_OPEN_VALUE = 32;
    public static final class_2746 END = class_2746.method_11825((String)"end");
    public static final class_2746 UNLOCKED = class_2746.method_11825((String)"unlocked");
    public static final class_2746 TEMP = class_2746.method_11825((String)"temp");

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (IBlock.getSideDirection(state) == direction && !newState.method_27852((class_2248)this)) {
            return class_2246.field_10124.method_9564();
        }
        class_2680 superState = super.method_9559(state, direction, newState, world, pos, posFrom);
        if (superState.method_26204() == class_2246.field_10124) {
            return superState;
        }
        boolean end = world.method_8320(pos.method_10093(IBlock.getSideDirection(state).method_10153())).method_26204() instanceof BlockPSDAPGGlassEndBase;
        return (class_2680)superState.method_11657((class_2769)END, (Comparable)Boolean.valueOf(end));
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 offsetPos = pos;
        if (IBlock.getStatePropertySafe(state, HALF) == class_2756.field_12609) {
            offsetPos = offsetPos.method_10074();
        }
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            offsetPos = offsetPos.method_10093(IBlock.getSideDirection(state));
        }
        IBlock.onBreakCreative(world, player, offsetPos);
        super.method_9576(world, pos, state, player);
    }

    @Override
    public void tick(class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 entity = world.method_8321(pos);
        if (((Boolean)IBlock.getStatePropertySafe(state, UNLOCKED)).booleanValue() && entity instanceof TileEntityPSDAPGDoorBase) {
            ((TileEntityPSDAPGDoorBase)entity).setOpen(0);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean unlocked = (Boolean)IBlock.getStatePropertySafe(state, UNLOCKED);
            for (int y = -1; y <= 1; ++y) {
                class_2680 scanState = world.method_8320(pos.method_10086(y));
                if (!state.method_27852(scanState.method_26204())) continue;
                BlockPSDAPGDoorBase.lockDoor(world, pos.method_10086(y), scanState, !unlocked);
            }
            player.method_7353((class_2561)(!unlocked ? Text.translatable("gui.mtr.psd_apg_door_unlocked", new Object[0]) : Text.translatable("gui.mtr.psd_apg_door_locked", new Object[0])), true);
        });
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 collisionContext) {
        class_2586 entity = world.method_8321(pos);
        return entity instanceof TileEntityPSDAPGDoorBase && ((TileEntityPSDAPGDoorBase)entity).isOpen() ? class_259.method_1073() : super.method_9549(state, world, pos, collisionContext);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{END, field_11177, HALF, SIDE, TEMP, UNLOCKED});
    }

    private static void lockDoor(class_1937 world, class_2338 pos, class_2680 state, boolean unlocked) {
        class_2680 toggled;
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, field_11177);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        class_2680 leftState = world.method_8320(leftPos);
        class_2680 rightState = world.method_8320(rightPos);
        if (leftState.method_27852(state.method_26204())) {
            toggled = (class_2680)leftState.method_11657((class_2769)UNLOCKED, (Comparable)Boolean.valueOf(unlocked));
            world.method_8501(leftPos, toggled);
        }
        if (rightState.method_27852(state.method_26204())) {
            toggled = (class_2680)rightState.method_11657((class_2769)UNLOCKED, (Comparable)Boolean.valueOf(unlocked));
            world.method_8501(rightPos, toggled);
        }
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)UNLOCKED, (Comparable)Boolean.valueOf(unlocked)));
    }

    public static abstract class TileEntityPSDAPGDoorBase
    extends BlockEntityClientSerializableMapper
    implements IGui {
        private int open;
        private float openClient;
        private boolean temp = true;
        private static final String KEY_OPEN = "open";
        private static final String KEY_TEMP = "temp";

        public TileEntityPSDAPGDoorBase(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(class_2487 compoundTag) {
            this.open = compoundTag.method_10550(KEY_OPEN);
            this.temp = compoundTag.method_10577(KEY_TEMP);
        }

        @Override
        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10569(KEY_OPEN, this.open);
            compoundTag.method_10556(KEY_TEMP, this.temp);
            if (this.temp && this.field_11863 != null) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)TEMP, (Comparable)Boolean.valueOf(false)));
                this.temp = false;
            }
        }

        public class_238 getRenderBoundingBox() {
            return new class_238(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public void setOpen(int open) {
            if (open != this.open) {
                this.open = open;
                this.method_5431();
                this.syncData();
                if (open == 1 && this.field_11863 != null) {
                    this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)TEMP, (Comparable)Boolean.valueOf(false)));
                }
            }
        }

        public float getOpen(float lastFrameDuration) {
            float change = lastFrameDuration * 0.95f;
            this.openClient = Math.abs((float)this.open - 0.1f - this.openClient) < change ? (float)this.open - 0.1f : (this.openClient < (float)this.open ? (this.openClient += change) : (this.openClient -= change));
            return this.openClient / 32.0f;
        }

        public boolean isOpen() {
            return this.open > 0;
        }
    }
}

