/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.Set;
import mtr.BlockEntityTypes;
import mtr.Blocks;
import mtr.Items;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDAPGGlassEndBase;
import mtr.block.BlockPSDDoor;
import mtr.block.BlockPSDGlass;
import mtr.block.BlockPSDGlassEnd;
import mtr.block.IBlock;
import mtr.data.DataCache;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class BlockPSDTop
extends BlockDirectionalMapper
implements EntityBlockMapper,
IBlock {
    private static final float PERSISTENT_OFFSET = 7.5f;
    public static final float PERSISTENT_OFFSET_SMALL = 0.46875f;
    public static final class_2746 AIR_LEFT = class_2746.method_11825((String)"air_left");
    public static final class_2746 AIR_RIGHT = class_2746.method_11825((String)"air_right");
    public static final class_2758 ARROW_DIRECTION = class_2758.method_11867((String)"propagate_property", (int)0, (int)3);
    public static final class_2754<EnumPersistent> PERSISTENT = class_2754.method_11850((String)"persistent", EnumPersistent.class);

    public BlockPSDTop() {
        super(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_16025).method_29292().method_9632(2.0f).method_22488());
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingItem(world, player, item -> {
            if (item == Items.BRUSH.get()) {
                world.method_8501(pos, (class_2680)state.method_28493((class_2769)ARROW_DIRECTION));
                this.propagate(world, pos, ((class_2350)IBlock.getStatePropertySafe(state, field_11177)).method_10170(), (class_2769)ARROW_DIRECTION, 1);
                this.propagate(world, pos, ((class_2350)IBlock.getStatePropertySafe(state, field_11177)).method_10160(), (class_2769)ARROW_DIRECTION, 1);
            } else {
                boolean shouldBePersistent = IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE;
                this.setState(world, pos, shouldBePersistent);
                this.propagate(world, pos, ((class_2350)IBlock.getStatePropertySafe(state, field_11177)).method_10170(), offsetPos -> this.setState(world, (class_2338)offsetPos, shouldBePersistent), 1);
                this.propagate(world, pos, ((class_2350)IBlock.getStatePropertySafe(state, field_11177)).method_10160(), offsetPos -> this.setState(world, (class_2338)offsetPos, shouldBePersistent), 1);
            }
        }, null, Items.BRUSH.get(), class_1802.field_8868);
    }

    private void setState(class_1937 world, class_2338 pos, boolean shouldBePersistent) {
        class_2248 blockBelow = world.method_8320(pos.method_10074()).method_26204();
        if (blockBelow instanceof BlockPSDDoor || blockBelow instanceof BlockPSDGlass || blockBelow instanceof BlockPSDGlassEnd) {
            if (shouldBePersistent) {
                world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657(PERSISTENT, (Comparable)((Object)(blockBelow instanceof BlockPSDDoor ? EnumPersistent.ARROW : (blockBelow instanceof BlockPSDGlass ? EnumPersistent.ROUTE : EnumPersistent.BLANK)))));
            } else {
                world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657(PERSISTENT, (Comparable)((Object)EnumPersistent.NONE)));
            }
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state;
    }

    public class_1792 method_8389() {
        return Items.PSD_GLASS_1.get();
    }

    public class_1799 method_9574(class_1922 blockGetter, class_2338 blockPos, class_2680 blockState) {
        return new class_1799((class_1935)this.method_8389());
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2248 blockDown = world.method_8320(pos.method_10074()).method_26204();
        if (blockDown instanceof BlockPSDAPGBase) {
            blockDown.method_9576(world, pos.method_10074(), world.method_8320(pos.method_10074()), player);
            world.method_8501(pos.method_10074(), class_2246.field_10124.method_9564());
        }
        super.method_9576(world, pos, state, player);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (direction == class_2350.field_11033 && IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE && !(newState.method_26204() instanceof BlockPSDAPGBase)) {
            return class_2246.field_10124.method_9564();
        }
        return BlockPSDTop.getActualState((class_1922)world, pos);
    }

    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 collisionContext) {
        class_265 baseShape = IBlock.getVoxelShapeByDirection(0.0, IBlock.getStatePropertySafe(state, PERSISTENT) == EnumPersistent.NONE ? 0.0 : 7.5, 0.0, 16.0, 16.0, 6.0, (class_2350)IBlock.getStatePropertySafe(state, field_11177));
        boolean airLeft = (Boolean)IBlock.getStatePropertySafe(state, AIR_LEFT);
        boolean airRight = (Boolean)IBlock.getStatePropertySafe(state, AIR_RIGHT);
        if (airLeft || airRight) {
            return BlockPSDAPGGlassEndBase.getEndOutlineShape(baseShape, state, 16, 6, airLeft, airRight);
        }
        return baseShape;
    }

    public class_3619 method_9527(class_2680 blockState) {
        return class_3619.field_15972;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, SIDE_EXTENDED, AIR_LEFT, AIR_RIGHT, ARROW_DIRECTION, PERSISTENT});
    }

    @Override
    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntityPSDTop(pos, state);
    }

    public static class_2680 getActualState(class_1922 world, class_2338 pos) {
        class_2680 oldState;
        class_2350 facing = null;
        IBlock.EnumSide side = null;
        boolean airLeft = false;
        boolean airRight = false;
        class_2680 stateBelow = world.method_8320(pos.method_10074());
        class_2248 blockBelow = stateBelow.method_26204();
        if (blockBelow instanceof BlockPSDGlass || blockBelow instanceof BlockPSDDoor || blockBelow instanceof BlockPSDGlassEnd) {
            side = blockBelow instanceof BlockPSDDoor ? (IBlock.EnumSide)((Object)IBlock.getStatePropertySafe(stateBelow, SIDE)) : (IBlock.EnumSide)((Object)IBlock.getStatePropertySafe(stateBelow, SIDE_EXTENDED));
            if (blockBelow instanceof BlockPSDGlassEnd) {
                if (IBlock.getStatePropertySafe(stateBelow, BlockPSDGlassEnd.TOUCHING_LEFT) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airLeft = true;
                }
                if (IBlock.getStatePropertySafe(stateBelow, BlockPSDGlassEnd.TOUCHING_RIGHT) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airRight = true;
                }
            }
            facing = (class_2350)IBlock.getStatePropertySafe(stateBelow, field_11177);
        }
        class_2680 newState = (class_2680)((class_2680)((oldState = world.method_8320(pos)).method_26204() instanceof BlockPSDTop ? oldState : Blocks.PSD_TOP.get().method_9564()).method_11657((class_2769)AIR_LEFT, (Comparable)Boolean.valueOf(airLeft))).method_11657((class_2769)AIR_RIGHT, (Comparable)Boolean.valueOf(airRight));
        if (facing != null) {
            newState = (class_2680)newState.method_11657((class_2769)field_11177, (Comparable)facing);
        }
        if (side != null) {
            newState = (class_2680)newState.method_11657((class_2769)SIDE_EXTENDED, (Comparable)((Object)side));
        }
        return newState;
    }

    public static enum EnumPersistent implements class_3542
    {
        NONE("none"),
        ARROW("arrow"),
        ROUTE("route"),
        BLANK("blank");

        private final String name;

        private EnumPersistent(String nameIn) {
            this.name = nameIn;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static class TileEntityPSDTop
    extends TileEntityRouteBase {
        public TileEntityPSDTop(class_2338 pos, class_2680 state) {
            super(BlockEntityTypes.PSD_TOP_TILE_ENTITY.get(), pos, state);
        }
    }

    public static enum EnumDoorLight implements class_3542
    {
        ON("on"),
        OFF("off"),
        NONE("none");

        private final String name;

        private EnumDoorLight(String nameIn) {
            this.name = nameIn;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static class TileEntityRouteBase
    extends BlockEntityMapper {
        private long cachedRefreshTime;
        private long cachedPlatformId;

        public TileEntityRouteBase(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state);
        }

        public long getPlatformId(Set<Platform> platforms, DataCache dataCache) {
            if (dataCache.needsRefresh(this.cachedRefreshTime)) {
                this.cachedPlatformId = RailwayData.getClosePlatformId(platforms, dataCache, this.method_11016());
                this.cachedRefreshTime = System.currentTimeMillis();
            }
            return this.cachedPlatformId;
        }
    }
}

