/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.block.BlockAPGDoor;
import mtr.block.BlockAPGGlass;
import mtr.block.BlockAPGGlassEnd;
import mtr.block.BlockPSDAPGDoorBase;
import mtr.block.BlockPSDDoor;
import mtr.block.BlockPSDGlass;
import mtr.block.BlockPSDGlassEnd;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class BlockPlatform
extends BlockDirectionalMapper {
    private final boolean isIndented;
    public static final class_2754<EnumDoorType> DOOR_TYPE = class_2754.method_11850((String)"door_type", EnumDoorType.class);
    public static final class_2758 SIDE = class_2758.method_11867((String)"side", (int)0, (int)4);

    public BlockPlatform(class_4970.class_2251 settings, boolean isIndented) {
        super(settings);
        this.isIndented = isIndented;
        this.method_9590((class_2680)this.method_9564().method_11657(DOOR_TYPE, (Comparable)((Object)EnumDoorType.NONE)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        return this.getActualState((class_1922)world, pos, state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042());
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (this.isIndented) {
            class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, field_11177);
            return class_259.method_1084((class_265)IBlock.getVoxelShapeByDirection(0.0, 0.0, 6.0, 16.0, 13.0, 16.0, facing), (class_265)class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        }
        return super.method_9530(state, world, pos, context);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, DOOR_TYPE, SIDE});
    }

    private class_2680 getActualState(class_1922 world, class_2338 pos, class_2680 state) {
        int side;
        EnumDoorType doorType;
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe(state, field_11177);
        class_2680 stateAbove = world.method_8320(pos.method_10084());
        class_2248 blockAbove = stateAbove.method_26204();
        if (blockAbove instanceof BlockPSDDoor || blockAbove instanceof BlockPSDGlass || blockAbove instanceof BlockPSDGlassEnd) {
            doorType = EnumDoorType.PSD;
            facing = (class_2350)IBlock.getStatePropertySafe(stateAbove, field_11177);
        } else if (blockAbove instanceof BlockAPGDoor || blockAbove instanceof BlockAPGGlass || blockAbove instanceof BlockAPGGlassEnd) {
            doorType = EnumDoorType.APG;
            facing = (class_2350)IBlock.getStatePropertySafe(stateAbove, field_11177);
        } else {
            doorType = EnumDoorType.NONE;
        }
        boolean aboveIsDoor = blockAbove instanceof BlockPSDAPGDoorBase;
        class_2680 stateLeftAbove = world.method_8320(pos.method_10084().method_10093(facing.method_10160()));
        boolean leftAboveIsDoor = stateLeftAbove.method_26204() instanceof BlockPSDAPGDoorBase;
        class_2680 stateRightAbove = world.method_8320(pos.method_10084().method_10093(facing.method_10170()));
        boolean rightAboveIsDoor = stateRightAbove.method_26204() instanceof BlockPSDAPGDoorBase;
        if (aboveIsDoor && rightAboveIsDoor) {
            side = 2;
        } else if (aboveIsDoor && leftAboveIsDoor) {
            side = 3;
        } else if (rightAboveIsDoor) {
            side = 1;
            facing = (class_2350)IBlock.getStatePropertySafe(stateRightAbove, field_11177);
        } else if (leftAboveIsDoor) {
            side = 4;
            facing = (class_2350)IBlock.getStatePropertySafe(stateLeftAbove, field_11177);
        } else {
            side = 0;
        }
        return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)field_11177, (Comparable)facing)).method_11657(DOOR_TYPE, (Comparable)((Object)doorType))).method_11657((class_2769)SIDE, (Comparable)Integer.valueOf(side));
    }

    private static enum EnumDoorType implements class_3542
    {
        NONE("none"),
        PSD("psd"),
        APG("apg");

        private final String name;

        private EnumDoorType(String nameIn) {
            this.name = nameIn;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

